// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale');
goog.require('cljs.core');
goog.require('active.clojure.record');
goog.require('active_viz.scale.types');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('active.clojure.lens');
active_viz.scale.make_linear_scale = (function active_viz$scale$make_linear_scale(p__8567,p__8568){
var vec__8569 = p__8567;
var domain_min = cljs.core.nth.call(null,vec__8569,(0),null);
var domain_max = cljs.core.nth.call(null,vec__8569,(1),null);
var vec__8572 = p__8568;
var range_min = cljs.core.nth.call(null,vec__8572,(0),null);
var range_max = cljs.core.nth.call(null,vec__8572,(1),null);
return active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [domain_min,domain_max], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null));
});
active_viz.scale.make_time_scale = (function active_viz$scale$make_time_scale(p__8575,p__8576){
var vec__8577 = p__8575;
var domain_min = cljs.core.nth.call(null,vec__8577,(0),null);
var domain_max = cljs.core.nth.call(null,vec__8577,(1),null);
var vec__8580 = p__8576;
var range_min = cljs.core.nth.call(null,vec__8580,(0),null);
var range_max = cljs.core.nth.call(null,vec__8580,(1),null);
return active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [domain_min,domain_max], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null));
});
active_viz.scale.collect_scales_reversed = (function active_viz$scale$collect_scales_reversed(scale){
var s = scale;
var acc = cljs.core.List.EMPTY;
while(true){
if(cljs.core.truth_(active_viz.scale.types.nop_QMARK_.call(null,s))){
return acc;
} else {
var G__8583 = active_viz.scale.types.scale_succ.call(null,s);
var G__8584 = cljs.core.cons.call(null,s,acc);
s = G__8583;
acc = G__8584;
continue;
}
break;
}
});
/**
 * Scales a value using the given scale.
 */
active_viz.scale.scale = (function active_viz$scale$scale(scale,value){
var s = scale;
var p = value;
while(true){
if(cljs.core.truth_(active_viz.scale.types.nop_QMARK_.call(null,s))){
return p;
} else {
var scale_params = active_viz.scale.types.scale_params.call(null,s);
var G__8585 = active_viz.scale.types.scale_succ.call(null,s);
var G__8586 = active_viz.scale.types.call.call(null,scale_params,s,p);
s = G__8585;
p = G__8586;
continue;
}
break;
}
});
/**
 * Scales the value inverted (reversed) using the given scale.
 */
active_viz.scale.scale_inverted = (function active_viz$scale$scale_inverted(scale,param){
return cljs.core.reduce.call(null,(function (param_SINGLEQUOTE_,s){
return active_viz.scale.types.call_inverse.call(null,active_viz.scale.types.scale_params.call(null,s),s,param_SINGLEQUOTE_);
}),param,active_viz.scale.collect_scales_reversed.call(null,scale));
});
/**
 * Combines two scales. Note that in evaluation scale1 is evaluated first.
 */
active_viz.scale._GT__GT_ = (function active_viz$scale$_GT__GT_(scale1,scale2){
var succ = active_viz.scale.types.scale_succ.call(null,scale1);
if(cljs.core.truth_(active_viz.scale.types.nop_QMARK_.call(null,succ))){
return active.clojure.lens.shove.call(null,scale1,active_viz.scale.types.scale_succ,scale2);
} else {
return active.clojure.lens.shove.call(null,scale1,active_viz.scale.types.scale_succ,active_viz.scale._GT__GT_.call(null,succ,scale2));
}
});
/**
 * Returns the range of a scale. That is the range of the last scale in succ.
 */
active_viz.scale.range = (function active_viz$scale$range(scale){
var last = (function (){var s = scale;
while(true){
if(cljs.core.truth_(active_viz.scale.types.nop_QMARK_.call(null,active_viz.scale.types.scale_succ.call(null,s)))){
return s;
} else {
var G__8587 = active_viz.scale.types.scale_succ.call(null,s);
s = G__8587;
continue;
}
break;
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [active_viz.scale.types.scale_range_min.call(null,last),active_viz.scale.types.scale_range_max.call(null,last)], null);
});
/**
 * Inverts the range of a scaling for the specified range.
 *   This is done by calculating the center of this range and mirroring target values.
 *   Thus, ranges must be defined correctly, thus.
 */
active_viz.scale.invert = (function active_viz$scale$invert(scale){
var vec__8588 = active_viz.scale.range.call(null,scale);
var min = cljs.core.nth.call(null,vec__8588,(0),null);
var max = cljs.core.nth.call(null,vec__8588,(1),null);
var inverting_scale = active_viz.scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min,max], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max,min], null));
return active_viz.scale._GT__GT_.call(null,scale,inverting_scale);
});
/**
 * Pads a scale in the sense of adding a offset defined in `padding` to the target range.
 */
active_viz.scale.pad = (function active_viz$scale$pad(scale,padding){
var vec__8591 = active_viz.scale.range.call(null,scale);
var min = cljs.core.nth.call(null,vec__8591,(0),null);
var max = cljs.core.nth.call(null,vec__8591,(1),null);
var padding_scale = active_viz.scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min,max], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(padding + min),(padding + max)], null));
return active_viz.scale._GT__GT_.call(null,scale,padding_scale);
});
/**
 * Pads a scale to 0. That is, it subtracts or adds an offset to the smallest range boundary, setting it to 0
 */
active_viz.scale.pad_to_zero = (function active_viz$scale$pad_to_zero(scale){
var negate = (function active_viz$scale$pad_to_zero_$_negate(v){
return ((-1) * v);
});
return active_viz.scale.pad.call(null,scale,negate.call(null,cljs.core.apply.call(null,cljs.core.min,active_viz.scale.range.call(null,scale))));
});
/**
 * Simply sets a new range in the last succ of scale, without altering anything else
 */
active_viz.scale.adjust_range = (function active_viz$scale$adjust_range(scale,p__8594){
var vec__8595 = p__8594;
var range_min = cljs.core.nth.call(null,vec__8595,(0),null);
var range_max = cljs.core.nth.call(null,vec__8595,(1),null);
if(cljs.core.truth_(active_viz.scale.types.nop_QMARK_.call(null,active_viz.scale.types.scale_succ.call(null,scale)))){
return active.clojure.lens.shove.call(null,active.clojure.lens.shove.call(null,scale,active_viz.scale.types.scale_range_min,range_min),active_viz.scale.types.scale_range_max,range_max);
} else {
return active.clojure.lens.shove.call(null,scale,active_viz.scale.types.scale_succ,active_viz.scale.adjust_range.call(null,active_viz.scale.types.scale_succ.call(null,scale),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null)));
}
});
/**
 * Returns the domain of a scale. That is the domain of the first scale
 */
active_viz.scale.domain = (function active_viz$scale$domain(scale){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [active_viz.scale.types.scale_domain_min.call(null,scale),active_viz.scale.types.scale_domain_max.call(null,scale)], null);
});
active_viz.scale.linear_scale__GT_ticks = (function active_viz$scale$linear_scale__GT_ticks(scale,num_ticks){
return active_viz.scale.linear_scale.linear_scale__GT_ticks.call(null,scale,num_ticks);
});
active_viz.scale.time_scale__GT_ticks = (function active_viz$scale$time_scale__GT_ticks(scale,type,num_ticks){
return active_viz.scale.time_scale.time_scale__GT_ticks.call(null,scale,type,num_ticks);
});

//# sourceMappingURL=scale.js.map
