// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.linear_scale');
goog.require('cljs.core');
goog.require('active_viz.ticks');
goog.require('active.clojure.record');
goog.require('active_viz.scale.types');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.linear_scale.LinearScaleParams = (function (a,b,__meta,__extmap,__hash){
this.a = a;
this.b = b;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8531,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8535 = k8531;
var G__8535__$1 = (((G__8535 instanceof cljs.core.Keyword))?G__8535.fqn:null);
switch (G__8535__$1) {
case "a":
return self__.a;

break;
case "b":
return self__.b;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8531,else__4206__auto__);

}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.linear-scale.LinearScaleParams{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"a","a",-2123407586),self__.a],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"b","b",1482224470),self__.b],null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8530){
var self__ = this;
var G__8530__$1 = this;
return (new cljs.core.RecordIter((0),G__8530__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1801074233 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8532,other8533){
var self__ = this;
var this8532__$1 = this;
return ((!((other8533 == null))) && ((this8532__$1.constructor === other8533.constructor)) && (cljs.core._EQ_.call(null,this8532__$1.a,other8533.a)) && (cljs.core._EQ_.call(null,this8532__$1.b,other8533.b)) && (cljs.core._EQ_.call(null,this8532__$1.__extmap,other8533.__extmap)));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param * self__.a) + self__.b);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param - self__.b) / self__.a);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"b","b",1482224470),null,new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8530){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8536 = cljs.core.keyword_identical_QMARK_;
var expr__8537 = k__4211__auto__;
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"a","a",-2123407586),expr__8537))){
return (new active_viz.scale.linear_scale.LinearScaleParams(G__8530,self__.b,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"b","b",1482224470),expr__8537))){
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,G__8530,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8530),null));
}
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"a","a",-2123407586),self__.a,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"b","b",1482224470),self__.b,null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8530){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,G__8530,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.linear_scale.LinearScaleParams.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null);
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$type = true;

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.linear-scale/LinearScaleParams",null,(1),null));
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.linear-scale/LinearScaleParams");
});

/**
 * Positional factory function for active-viz.scale.linear-scale/LinearScaleParams.
 */
active_viz.scale.linear_scale.__GT_LinearScaleParams = (function active_viz$scale$linear_scale$__GT_LinearScaleParams(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});

/**
 * Factory function for active-viz.scale.linear-scale/LinearScaleParams, taking a map of keywords to field values.
 */
active_viz.scale.linear_scale.map__GT_LinearScaleParams = (function active_viz$scale$linear_scale$map__GT_LinearScaleParams(G__8534){
var extmap__4236__auto__ = (function (){var G__8539 = cljs.core.dissoc.call(null,G__8534,new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470));
if(cljs.core.record_QMARK_.call(null,G__8534)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8539);
} else {
return G__8539;
}
})();
return (new active_viz.scale.linear_scale.LinearScaleParams(new cljs.core.Keyword(null,"a","a",-2123407586).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"b","b",1482224470).cljs$core$IFn$_invoke$arity$1(G__8534),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `LinearScaleParams` record? See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_params_QMARK_ = (function active_viz$scale$linear_scale$linear_scale_params_QMARK_(x__8461__auto__){
return (x__8461__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams);
});

/**
 * Construct a `LinearScaleParams` record.
 * 
 * `a`: access via [[active-viz.scale.linear-scale/linear-scale-a]]
 * `b`: access via [[active-viz.scale.linear-scale/linear-scale-b]]
 */
active_viz.scale.linear_scale.make_linear_scale_params = (function active_viz$scale$linear_scale$make_linear_scale_params(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});



/**
 * Lens for the `a` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_a = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.linear_scale.LinearScaleParams,rec__8458__auto__);

return rec__8458__auto__.a;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.linear_scale.make_linear_scale_params.call(null,v__8460__auto__,active_viz.scale.linear_scale.linear_scale_b.call(null,data__8459__auto__));
}));


/**
 * Lens for the `b` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_b = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.linear_scale.LinearScaleParams,rec__8458__auto__);

return rec__8458__auto__.b;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.linear_scale.make_linear_scale_params.call(null,active_viz.scale.linear_scale.linear_scale_a.call(null,data__8459__auto__),v__8460__auto__);
}));

active_viz.scale.linear_scale.make_linear_scale = (function active_viz$scale$linear_scale$make_linear_scale(p__8541,p__8542){
var vec__8543 = p__8541;
var domain_min = cljs.core.nth.call(null,vec__8543,(0),null);
var domain_max = cljs.core.nth.call(null,vec__8543,(1),null);
var vec__8546 = p__8542;
var range_min = cljs.core.nth.call(null,vec__8546,(0),null);
var range_max = cljs.core.nth.call(null,vec__8546,(1),null);
var domain_spread = (domain_max - domain_min);
var range_spread = (range_max - range_min);
var a = (range_spread / domain_spread);
var b = (range_min - (domain_min * a));
return active_viz.scale.types.make_scale.call(null,domain_min,domain_max,range_min,range_max,active_viz.scale.linear_scale.make_linear_scale_params.call(null,a,b),active_viz.scale.types.nop);
});
active_viz.scale.linear_scale.to_ticks = (function active_viz$scale$linear_scale$to_ticks(p__8549){
var map__8550 = p__8549;
var map__8550__$1 = ((((!((map__8550 == null)))?(((((map__8550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8550):map__8550);
var lstep = cljs.core.get.call(null,map__8550__$1,new cljs.core.Keyword(null,"lstep","lstep",-1243990033));
var lmin = cljs.core.get.call(null,map__8550__$1,new cljs.core.Keyword(null,"lmin","lmin",2139111947));
var lmax = cljs.core.get.call(null,map__8550__$1,new cljs.core.Keyword(null,"lmax","lmax",-1390660950));
var current = lmin;
var acc = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lmin], null);
while(true){
var next = (lstep + cljs.core.first.call(null,acc));
if((next > lmax)){
return acc;
} else {
var G__8552 = next;
var G__8553 = cljs.core.cons.call(null,next,acc);
current = G__8552;
acc = G__8553;
continue;
}
break;
}
});
active_viz.scale.linear_scale.ticks = (function active_viz$scale$linear_scale$ticks(domain_min,domain_max,num_ticks){
var G__8554 = active_viz.ticks.nice_ticks.call(null,domain_min,domain_max,num_ticks);
if((G__8554 == null)){
return null;
} else {
return active_viz.scale.linear_scale.to_ticks.call(null,G__8554);
}
});
active_viz.scale.linear_scale.linear_scale__GT_ticks = (function active_viz$scale$linear_scale$linear_scale__GT_ticks(scale,num_ticks){
return active_viz.scale.linear_scale.ticks.call(null,active_viz.scale.types.scale_domain_min.call(null,scale),active_viz.scale.types.scale_domain_max.call(null,scale),num_ticks);
});

//# sourceMappingURL=linear_scale.js.map
