// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.time_scale');
goog.require('cljs.core');
goog.require('cljs_time.coerce');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('active_viz.scale.linear_scale');
goog.require('active.clojure.record');
goog.require('active_viz.ticks');
goog.require('active_viz.scale.types');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.time_scale.Unit = (function (time_unit,time_constructor,approx_ms,nice_values,__meta,__extmap,__hash){
this.time_unit = time_unit;
this.time_constructor = time_constructor;
this.approx_ms = approx_ms;
this.nice_values = nice_values;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8531,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8535 = k8531;
var G__8535__$1 = (((G__8535 instanceof cljs.core.Keyword))?G__8535.fqn:null);
switch (G__8535__$1) {
case "time-unit":
return self__.time_unit;

break;
case "time-constructor":
return self__.time_constructor;

break;
case "approx-ms":
return self__.approx_ms;

break;
case "nice-values":
return self__.nice_values;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8531,else__4206__auto__);

}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.time-scale.Unit{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values],null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8530){
var self__ = this;
var G__8530__$1 = this;
return (new cljs.core.RecordIter((0),G__8530__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1780693712 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8532,other8533){
var self__ = this;
var this8532__$1 = this;
return ((!((other8533 == null))) && ((this8532__$1.constructor === other8533.constructor)) && (cljs.core._EQ_.call(null,this8532__$1.time_unit,other8533.time_unit)) && (cljs.core._EQ_.call(null,this8532__$1.time_constructor,other8533.time_constructor)) && (cljs.core._EQ_.call(null,this8532__$1.approx_ms,other8533.approx_ms)) && (cljs.core._EQ_.call(null,this8532__$1.nice_values,other8533.nice_values)) && (cljs.core._EQ_.call(null,this8532__$1.__extmap,other8533.__extmap)));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"nice-values","nice-values",9595080),null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8530){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8536 = cljs.core.keyword_identical_QMARK_;
var expr__8537 = k__4211__auto__;
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),expr__8537))){
return (new active_viz.scale.time_scale.Unit(G__8530,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),expr__8537))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,G__8530,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),expr__8537))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,G__8530,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__8536.call(null,new cljs.core.Keyword(null,"nice-values","nice-values",9595080),expr__8537))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,G__8530,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8530),null));
}
}
}
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values,null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8530){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,G__8530,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.time_scale.Unit.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"time-unit","time-unit",-1996119505,null),new cljs.core.Symbol(null,"time-constructor","time-constructor",1975064803,null),new cljs.core.Symbol(null,"approx-ms","approx-ms",-929702522,null),new cljs.core.Symbol(null,"nice-values","nice-values",1650126607,null)], null);
});

active_viz.scale.time_scale.Unit.cljs$lang$type = true;

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.time-scale/Unit",null,(1),null));
});

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.time-scale/Unit");
});

/**
 * Positional factory function for active-viz.scale.time-scale/Unit.
 */
active_viz.scale.time_scale.__GT_Unit = (function active_viz$scale$time_scale$__GT_Unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});

/**
 * Factory function for active-viz.scale.time-scale/Unit, taking a map of keywords to field values.
 */
active_viz.scale.time_scale.map__GT_Unit = (function active_viz$scale$time_scale$map__GT_Unit(G__8534){
var extmap__4236__auto__ = (function (){var G__8539 = cljs.core.dissoc.call(null,G__8534,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080));
if(cljs.core.record_QMARK_.call(null,G__8534)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8539);
} else {
return G__8539;
}
})();
return (new active_viz.scale.time_scale.Unit(new cljs.core.Keyword(null,"time-unit","time-unit",658316264).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247).cljs$core$IFn$_invoke$arity$1(G__8534),new cljs.core.Keyword(null,"nice-values","nice-values",9595080).cljs$core$IFn$_invoke$arity$1(G__8534),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Unit` record? See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_QMARK_ = (function active_viz$scale$time_scale$unit_QMARK_(x__8461__auto__){
return (x__8461__auto__ instanceof active_viz.scale.time_scale.Unit);
});

/**
 * Construct a `Unit` record.
 * 
 * `time-unit`: access via [[active-viz.scale.time-scale/unit-time-unit]]
 * `time-constructor`: access via [[active-viz.scale.time-scale/unit-time-constructor]]
 * `approx-ms`: access via [[active-viz.scale.time-scale/unit-approx-ms]]
 * `nice-values`: access via [[active-viz.scale.time-scale/unit-nice-values]]
 */
active_viz.scale.time_scale.make_unit = (function active_viz$scale$time_scale$make_unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});





/**
 * Lens for the `time-unit` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_unit = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8458__auto__);

return rec__8458__auto__.time_unit;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.time_scale.make_unit.call(null,v__8460__auto__,active_viz.scale.time_scale.unit_time_constructor.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_approx_ms.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_nice_values.call(null,data__8459__auto__));
}));


/**
 * Lens for the `time-constructor` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_constructor = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8458__auto__);

return rec__8458__auto__.time_constructor;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.time_scale.make_unit.call(null,active_viz.scale.time_scale.unit_time_unit.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.time_scale.unit_approx_ms.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_nice_values.call(null,data__8459__auto__));
}));


/**
 * Lens for the `approx-ms` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_approx_ms = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8458__auto__);

return rec__8458__auto__.approx_ms;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.time_scale.make_unit.call(null,active_viz.scale.time_scale.unit_time_unit.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_time_constructor.call(null,data__8459__auto__),v__8460__auto__,active_viz.scale.time_scale.unit_nice_values.call(null,data__8459__auto__));
}));


/**
 * Lens for the `nice-values` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_nice_values = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.Unit,rec__8458__auto__);

return rec__8458__auto__.nice_values;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.time_scale.make_unit.call(null,active_viz.scale.time_scale.unit_time_unit.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_time_constructor.call(null,data__8459__auto__),active_viz.scale.time_scale.unit_approx_ms.call(null,data__8459__auto__),v__8460__auto__);
}));

active_viz.scale.time_scale.millisecond = (1);
active_viz.scale.time_scale.second_ms = ((1000) * active_viz.scale.time_scale.millisecond);
active_viz.scale.time_scale.minute_ms = ((60) * active_viz.scale.time_scale.second_ms);
active_viz.scale.time_scale.hour_ms = ((60) * active_viz.scale.time_scale.minute_ms);
active_viz.scale.time_scale.day_ms = ((24) * active_viz.scale.time_scale.hour_ms);
active_viz.scale.time_scale.month_ms = ((30) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.year_ms = ((365) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.millisecond_nice = new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(5),(2),2.5,(3),(4),1.5,(7),(6),(8),(9)], null);
active_viz.scale.time_scale.second_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(10),(20),(30),(60)], null);
active_viz.scale.time_scale.minute_nice = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(5),(10),(15),(30),(60)], null);
active_viz.scale.time_scale.hour_nice = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(24)], null);
active_viz.scale.time_scale.day_nice = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(10),(15),(30),182.5,(365)], null);
active_viz.scale.time_scale.month_nice = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(3)], null);
active_viz.scale.time_scale.year_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(6),(7),(8),(9)], null);
active_viz.scale.time_scale.year_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.year,cljs_time.core.years,active_viz.scale.time_scale.year_ms,active_viz.scale.time_scale.year_nice);
active_viz.scale.time_scale.month_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.month,cljs_time.core.months,active_viz.scale.time_scale.month_ms,active_viz.scale.time_scale.month_nice);
active_viz.scale.time_scale.day_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.day,cljs_time.core.days,active_viz.scale.time_scale.day_ms,active_viz.scale.time_scale.day_nice);
active_viz.scale.time_scale.hour_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.hour,cljs_time.core.hours,active_viz.scale.time_scale.hour_ms,active_viz.scale.time_scale.hour_nice);
active_viz.scale.time_scale.minute_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.minute,cljs_time.core.minutes,active_viz.scale.time_scale.minute_ms,active_viz.scale.time_scale.minute_nice);
active_viz.scale.time_scale.second_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.second,cljs_time.core.seconds,active_viz.scale.time_scale.second_ms,active_viz.scale.time_scale.second_nice);
active_viz.scale.time_scale.ms_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.millis,cljs_time.core.millis,active_viz.scale.time_scale.millisecond,active_viz.scale.time_scale.millisecond_nice);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.time_scale.TimeScaleParams = (function (linear_scale,__meta,__extmap,__hash){
this.linear_scale = linear_scale;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k8542,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__8546 = k8542;
var G__8546__$1 = (((G__8546 instanceof cljs.core.Keyword))?G__8546.fqn:null);
switch (G__8546__$1) {
case "linear-scale":
return self__.linear_scale;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k8542,else__4206__auto__);

}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.time-scale.TimeScaleParams{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),self__.linear_scale],null))], null),self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__8541){
var self__ = this;
var G__8541__$1 = this;
return (new cljs.core.RecordIter((0),G__8541__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1743401513 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this8543,other8544){
var self__ = this;
var this8543__$1 = this;
return ((!((other8544 == null))) && ((this8543__$1.constructor === other8544.constructor)) && (cljs.core._EQ_.call(null,this8543__$1.linear_scale,other8544.linear_scale)) && (cljs.core._EQ_.call(null,this8543__$1.__extmap,other8544.__extmap)));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
var param_ms = cljs_time.coerce.to_long.call(null,param);
return active_viz.scale.types.call.call(null,active_viz.scale.types.scale_params.call(null,self__.linear_scale),self__.linear_scale,param_ms);
});

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return cljs_time.coerce.from_long.call(null,active_viz.scale.types.call_inverse.call(null,active_viz.scale.types.scale_params.call(null,self__.linear_scale),self__.linear_scale,param));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__8541){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__8547 = cljs.core.keyword_identical_QMARK_;
var expr__8548 = k__4211__auto__;
if(cljs.core.truth_(pred__8547.call(null,new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),expr__8548))){
return (new active_viz.scale.time_scale.TimeScaleParams(G__8541,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__8541),null));
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),self__.linear_scale,null))], null),self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__8541){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,G__8541,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.time_scale.TimeScaleParams.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null)], null);
});

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$type = true;

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale.time-scale/TimeScaleParams",null,(1),null));
});

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale.time-scale/TimeScaleParams");
});

/**
 * Positional factory function for active-viz.scale.time-scale/TimeScaleParams.
 */
active_viz.scale.time_scale.__GT_TimeScaleParams = (function active_viz$scale$time_scale$__GT_TimeScaleParams(linear_scale){
return (new active_viz.scale.time_scale.TimeScaleParams(linear_scale,null,null,null));
});

/**
 * Factory function for active-viz.scale.time-scale/TimeScaleParams, taking a map of keywords to field values.
 */
active_viz.scale.time_scale.map__GT_TimeScaleParams = (function active_viz$scale$time_scale$map__GT_TimeScaleParams(G__8545){
var extmap__4236__auto__ = (function (){var G__8550 = cljs.core.dissoc.call(null,G__8545,new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221));
if(cljs.core.record_QMARK_.call(null,G__8545)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__8550);
} else {
return G__8550;
}
})();
return (new active_viz.scale.time_scale.TimeScaleParams(new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221).cljs$core$IFn$_invoke$arity$1(G__8545),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `TimeScaleParams` record? See [[active-viz.scale.time-scale/make-time-scale-params]].
 */
active_viz.scale.time_scale.time_scale_params_QMARK_ = (function active_viz$scale$time_scale$time_scale_params_QMARK_(x__8461__auto__){
return (x__8461__auto__ instanceof active_viz.scale.time_scale.TimeScaleParams);
});

/**
 * Construct a `TimeScaleParams` record.
 * 
 * `linear-scale`: access via [[active-viz.scale.time-scale/time-scale-params-linear-scale]]
 */
active_viz.scale.time_scale.make_time_scale_params = (function active_viz$scale$time_scale$make_time_scale_params(linear_scale){
return (new active_viz.scale.time_scale.TimeScaleParams(linear_scale,null,null,null));
});


/**
 * Lens for the `linear-scale` field from a [[TimeScaleParams]] record. See [[active-viz.scale.time-scale/make-time-scale-params]].
 */
active_viz.scale.time_scale.time_scale_params_linear_scale = active.clojure.lens.lens.call(null,(function (rec__8458__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.time_scale.TimeScaleParams,rec__8458__auto__);

return rec__8458__auto__.linear_scale;
}),(function (data__8459__auto__,v__8460__auto__){
return active_viz.scale.time_scale.make_time_scale_params.call(null,v__8460__auto__);
}));

active_viz.scale.time_scale.make_time_scale = (function active_viz$scale$time_scale$make_time_scale(p__8552,p__8553){
var vec__8554 = p__8552;
var domain_min = cljs.core.nth.call(null,vec__8554,(0),null);
var domain_max = cljs.core.nth.call(null,vec__8554,(1),null);
var vec__8557 = p__8553;
var range_min = cljs.core.nth.call(null,vec__8557,(0),null);
var range_max = cljs.core.nth.call(null,vec__8557,(1),null);
var start_date_ms = cljs_time.coerce.to_long.call(null,domain_min);
var end_date_ms = cljs_time.coerce.to_long.call(null,domain_max);
var linear_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_ms,end_date_ms], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null));
return active_viz.scale.types.make_scale.call(null,domain_min,domain_max,range_min,range_max,active_viz.scale.time_scale.make_time_scale_params.call(null,linear_scale),active_viz.scale.types.nop);
});
active_viz.scale.time_scale.find_nice_value = (function active_viz$scale$time_scale$find_nice_value(start_date,end_date,num_ticks,unit){
return cljs.core.second.call(null,(function (){var unit_ms = active_viz.scale.time_scale.unit_approx_ms.call(null,unit);
var nice_values = active_viz.scale.time_scale.unit_nice_values.call(null,unit);
var interval = (cljs_time.coerce.to_long.call(null,end_date) - cljs_time.coerce.to_long.call(null,start_date));
var score_fn = ((function (unit_ms,nice_values,interval){
return (function (nice_val){
return Math.abs((num_ticks - (interval / (nice_val * unit_ms))));
});})(unit_ms,nice_values,interval))
;
return cljs.core.reduce.call(null,((function (unit_ms,nice_values,interval,score_fn){
return (function (p__8560,nice_value){
var vec__8561 = p__8560;
var best_score = cljs.core.nth.call(null,vec__8561,(0),null);
var best_nice_value = cljs.core.nth.call(null,vec__8561,(1),null);
var score = score_fn.call(null,nice_value);
if(cljs.core.truth_((function (){var and__3938__auto__ = best_score;
if(cljs.core.truth_(and__3938__auto__)){
return (best_score > score);
} else {
return and__3938__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [score,nice_value], null);
} else {
if(cljs.core.truth_(best_score)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [best_score,best_nice_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [score,nice_value], null);

}
}
});})(unit_ms,nice_values,interval,score_fn))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),nice_values);
})());
});
active_viz.scale.time_scale.t_GT__EQ_ = (function active_viz$scale$time_scale$t_GT__EQ_(a,b){
var a_ms = cljs_time.coerce.to_long.call(null,a);
var b_ms = cljs_time.coerce.to_long.call(null,b);
return (a_ms >= b_ms);
});
active_viz.scale.time_scale.time_ceiling = (function active_viz$scale$time_scale$time_ceiling(t,unit,constructor$){
if(cljs.core._EQ_.call(null,cljs_time.coerce.to_long.call(null,cljs_time.core.floor.call(null,t,unit)),cljs_time.coerce.to_long.call(null,t))){
return t;
} else {
return cljs_time.core.floor.call(null,cljs_time.core.plus.call(null,t,constructor$.call(null,(1))),unit);
}
});
active_viz.scale.time_scale.recommend_unit = (function active_viz$scale$time_scale$recommend_unit(start_date,end_date){
var interval = (cljs_time.coerce.to_long.call(null,end_date) - cljs_time.coerce.to_long.call(null,start_date));
var gt = ((function (interval){
return (function (v){
return (interval > v);
});})(interval))
;
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.month_ms * (36))))){
return active_viz.scale.time_scale.year_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.day_ms * (90))))){
return active_viz.scale.time_scale.month_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.hour_ms * (72))))){
return active_viz.scale.time_scale.day_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.minute_ms * (180))))){
return active_viz.scale.time_scale.hour_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.second_ms * (180))))){
return active_viz.scale.time_scale.minute_unit;
} else {
if(cljs.core.truth_(gt.call(null,(3000)))){
return active_viz.scale.time_scale.second_unit;
} else {
return active_viz.scale.time_scale.ms_unit;

}
}
}
}
}
}
});
active_viz.scale.time_scale.create_ticks = (function active_viz$scale$time_scale$create_ticks(start_date,end_date,num_ticks,unit){
var constructor$ = active_viz.scale.time_scale.unit_time_constructor.call(null,unit);
var nice_values = active_viz.scale.time_scale.unit_nice_values.call(null,unit);
var time_unit = active_viz.scale.time_scale.unit_time_unit.call(null,unit);
var floor = cljs_time.core.floor.call(null,start_date,time_unit);
var ceiling = active_viz.scale.time_scale.time_ceiling.call(null,end_date,time_unit,constructor$);
var nice_value = active_viz.scale.time_scale.find_nice_value.call(null,floor,ceiling,num_ticks,unit);
var acc = (new cljs.core.List(null,floor,null,(1),null));
while(true){
var next_date = cljs_time.core.plus.call(null,cljs.core.first.call(null,acc),constructor$.call(null,nice_value));
var next_dates = cljs.core.cons.call(null,next_date,acc);
if(cljs.core.truth_(active_viz.scale.time_scale.t_GT__EQ_.call(null,next_date,end_date))){
return next_dates;
} else {
var G__8564 = next_dates;
acc = G__8564;
continue;
}
break;
}
});
active_viz.scale.time_scale.time_scale__GT_ticks = (function active_viz$scale$time_scale$time_scale__GT_ticks(scale,unit,num_ticks){
var start_date = active_viz.scale.types.scale_domain_min.call(null,scale);
var end_date = active_viz.scale.types.scale_domain_max.call(null,scale);
return active_viz.scale.time_scale.create_ticks.call(null,start_date,end_date,num_ticks,unit);
});
active_viz.scale.time_scale.year_formatter = cljs_time.format.formatter.call(null,"yyyy");
active_viz.scale.time_scale.format_year = (function active_viz$scale$time_scale$format_year(dt){
if(cljs.core._EQ_.call(null,(1),cljs_time.core.month.call(null,dt))){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.year_formatter,dt);
} else {
return "";
}
});
active_viz.scale.time_scale.month_formatter = cljs_time.format.formatter.call(null,"MM/yyyy");
active_viz.scale.time_scale.format_month = (function active_viz$scale$time_scale$format_month(dt){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.month_formatter,dt);
});

//# sourceMappingURL=time_scale.js.map
