// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale');
goog.require('cljs.core');
goog.require('active.clojure.record');
goog.require('active.clojure.lens');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.Scale = (function (domain_min,domain_max,range_min,range_max,fun,succ,__meta,__extmap,__hash){
this.domain_min = domain_min;
this.domain_max = domain_max;
this.range_min = range_min;
this.range_max = range_max;
this.fun = fun;
this.succ = succ;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.Scale.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.Scale.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k21481,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__21485 = k21481;
var G__21485__$1 = (((G__21485 instanceof cljs.core.Keyword))?G__21485.fqn:null);
switch (G__21485__$1) {
case "domain-min":
return self__.domain_min;

break;
case "domain-max":
return self__.domain_max;

break;
case "range-min":
return self__.range_min;

break;
case "range-max":
return self__.range_max;

break;
case "fun":
return self__.fun;

break;
case "succ":
return self__.succ;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21481,else__4206__auto__);

}
});

active_viz.scale.Scale.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.Scale{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fun","fun",-1265158045),self__.fun],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"succ","succ",1386276271),self__.succ],null))], null),self__.__extmap));
});

active_viz.scale.Scale.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21480){
var self__ = this;
var G__21480__$1 = this;
return (new cljs.core.RecordIter((0),G__21480__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"succ","succ",1386276271)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.Scale.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.Scale.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.fun,self__.succ,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.Scale.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.Scale.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (318234892 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.Scale.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21482,other21483){
var self__ = this;
var this21482__$1 = this;
return ((!((other21483 == null))) && ((this21482__$1.constructor === other21483.constructor)) && (cljs.core._EQ_.call(null,this21482__$1.domain_min,other21483.domain_min)) && (cljs.core._EQ_.call(null,this21482__$1.domain_max,other21483.domain_max)) && (cljs.core._EQ_.call(null,this21482__$1.range_min,other21483.range_min)) && (cljs.core._EQ_.call(null,this21482__$1.range_max,other21483.range_max)) && (cljs.core._EQ_.call(null,this21482__$1.fun,other21483.fun)) && (cljs.core._EQ_.call(null,this21482__$1.succ,other21483.succ)) && (cljs.core._EQ_.call(null,this21482__$1.__extmap,other21483.__extmap)));
});

active_viz.scale.Scale.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"fun","fun",-1265158045),null,new cljs.core.Keyword(null,"domain-max","domain-max",150908843),null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),null,new cljs.core.Keyword(null,"succ","succ",1386276271),null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.fun,self__.succ,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.Scale.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__21480){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__21486 = cljs.core.keyword_identical_QMARK_;
var expr__21487 = k__4211__auto__;
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),expr__21487))){
return (new active_viz.scale.Scale(G__21480,self__.domain_max,self__.range_min,self__.range_max,self__.fun,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"domain-max","domain-max",150908843),expr__21487))){
return (new active_viz.scale.Scale(self__.domain_min,G__21480,self__.range_min,self__.range_max,self__.fun,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"range-min","range-min",-797195752),expr__21487))){
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,G__21480,self__.range_max,self__.fun,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"range-max","range-max",-1850570674),expr__21487))){
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,G__21480,self__.fun,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"fun","fun",-1265158045),expr__21487))){
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,G__21480,self__.succ,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21486.call(null,new cljs.core.Keyword(null,"succ","succ",1386276271),expr__21487))){
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.fun,G__21480,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.fun,self__.succ,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__21480),null));
}
}
}
}
}
}
});

active_viz.scale.Scale.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),self__.domain_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"domain-max","domain-max",150908843),self__.domain_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-min","range-min",-797195752),self__.range_min,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"range-max","range-max",-1850570674),self__.range_max,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fun","fun",-1265158045),self__.fun,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"succ","succ",1386276271),self__.succ,null))], null),self__.__extmap));
});

active_viz.scale.Scale.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__21480){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.Scale(self__.domain_min,self__.domain_max,self__.range_min,self__.range_max,self__.fun,self__.succ,G__21480,self__.__extmap,self__.__hash));
});

active_viz.scale.Scale.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.Scale.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"domain-min","domain-min",594257592,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"minimum domain value"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"domain-max","domain-max",1791440370,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"maximum domain value"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"range-min","range-min",843335775,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"minimum target range value. Expected to be numerical."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"range-max","range-max",-210039147,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"maximum target range value. Expected to be numerical."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"fun","fun",375373482,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"mapping fun from domain to range, defining the type of scale"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"succ","succ",-1268159498,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"successor of the scale, when combined"], null))], null);
});

active_viz.scale.Scale.cljs$lang$type = true;

active_viz.scale.Scale.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale/Scale",null,(1),null));
});

active_viz.scale.Scale.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale/Scale");
});

/**
 * Positional factory function for active-viz.scale/Scale.
 */
active_viz.scale.__GT_Scale = (function active_viz$scale$__GT_Scale(domain_min,domain_max,range_min,range_max,fun,succ){
return (new active_viz.scale.Scale(domain_min,domain_max,range_min,range_max,fun,succ,null,null,null));
});

/**
 * Factory function for active-viz.scale/Scale, taking a map of keywords to field values.
 */
active_viz.scale.map__GT_Scale = (function active_viz$scale$map__GT_Scale(G__21484){
var extmap__4236__auto__ = (function (){var G__21489 = cljs.core.dissoc.call(null,G__21484,new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935),new cljs.core.Keyword(null,"domain-max","domain-max",150908843),new cljs.core.Keyword(null,"range-min","range-min",-797195752),new cljs.core.Keyword(null,"range-max","range-max",-1850570674),new cljs.core.Keyword(null,"fun","fun",-1265158045),new cljs.core.Keyword(null,"succ","succ",1386276271));
if(cljs.core.record_QMARK_.call(null,G__21484)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21489);
} else {
return G__21489;
}
})();
return (new active_viz.scale.Scale(new cljs.core.Keyword(null,"domain-min","domain-min",-1046273935).cljs$core$IFn$_invoke$arity$1(G__21484),new cljs.core.Keyword(null,"domain-max","domain-max",150908843).cljs$core$IFn$_invoke$arity$1(G__21484),new cljs.core.Keyword(null,"range-min","range-min",-797195752).cljs$core$IFn$_invoke$arity$1(G__21484),new cljs.core.Keyword(null,"range-max","range-max",-1850570674).cljs$core$IFn$_invoke$arity$1(G__21484),new cljs.core.Keyword(null,"fun","fun",-1265158045).cljs$core$IFn$_invoke$arity$1(G__21484),new cljs.core.Keyword(null,"succ","succ",1386276271).cljs$core$IFn$_invoke$arity$1(G__21484),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Scale` record? See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_QMARK_ = (function active_viz$scale$scale_QMARK_(x__20517__auto__){
return (x__20517__auto__ instanceof active_viz.scale.Scale);
});

/**
 * Construct a `Scale` (A scale represents a function from a domain described by `domain-min` and `domain-max` into a
 *   a target range between `range-min` and `range-max`. The range values must be numerical.
 *   Domain boundaries as well as range boundaries are expected to be ordered correctly.
 *   The actual mapping is defined in `scale-fn`) record.
 * 
 * `domain-min` (minimum domain value): access via [[active-viz.scale/scale-domain-min]]
 * `domain-max` (maximum domain value): access via [[active-viz.scale/scale-domain-max]]
 * `range-min` (minimum target range value. Expected to be numerical.): access via [[active-viz.scale/scale-range-min]]
 * `range-max` (maximum target range value. Expected to be numerical.): access via [[active-viz.scale/scale-range-max]]
 * `fun` (mapping fun from domain to range, defining the type of scale): access via [[active-viz.scale/scale-fun]]
 * `succ` (successor of the scale, when combined): access via [[active-viz.scale/scale-succ]]
 */
active_viz.scale.make_scale = (function active_viz$scale$make_scale(domain_min,domain_max,range_min,range_max,fun,succ){
return (new active_viz.scale.Scale(domain_min,domain_max,range_min,range_max,fun,succ,null,null,null));
});







/**
 * Lens for the `domain-min` field (minimum domain value) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_domain_min = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.domain_min;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,v__20516__auto__,active_viz.scale.scale_domain_max.call(null,data__20515__auto__),active_viz.scale.scale_range_min.call(null,data__20515__auto__),active_viz.scale.scale_range_max.call(null,data__20515__auto__),active_viz.scale.scale_fun.call(null,data__20515__auto__),active_viz.scale.scale_succ.call(null,data__20515__auto__));
}));


/**
 * Lens for the `domain-max` field (maximum domain value) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_domain_max = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.domain_max;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,data__20515__auto__),v__20516__auto__,active_viz.scale.scale_range_min.call(null,data__20515__auto__),active_viz.scale.scale_range_max.call(null,data__20515__auto__),active_viz.scale.scale_fun.call(null,data__20515__auto__),active_viz.scale.scale_succ.call(null,data__20515__auto__));
}));


/**
 * Lens for the `range-min` field (minimum target range value. Expected to be numerical.) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_range_min = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.range_min;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,data__20515__auto__),active_viz.scale.scale_domain_max.call(null,data__20515__auto__),v__20516__auto__,active_viz.scale.scale_range_max.call(null,data__20515__auto__),active_viz.scale.scale_fun.call(null,data__20515__auto__),active_viz.scale.scale_succ.call(null,data__20515__auto__));
}));


/**
 * Lens for the `range-max` field (maximum target range value. Expected to be numerical.) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_range_max = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.range_max;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,data__20515__auto__),active_viz.scale.scale_domain_max.call(null,data__20515__auto__),active_viz.scale.scale_range_min.call(null,data__20515__auto__),v__20516__auto__,active_viz.scale.scale_fun.call(null,data__20515__auto__),active_viz.scale.scale_succ.call(null,data__20515__auto__));
}));


/**
 * Lens for the `fun` field (mapping fun from domain to range, defining the type of scale) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_fun = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.fun;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,data__20515__auto__),active_viz.scale.scale_domain_max.call(null,data__20515__auto__),active_viz.scale.scale_range_min.call(null,data__20515__auto__),active_viz.scale.scale_range_max.call(null,data__20515__auto__),v__20516__auto__,active_viz.scale.scale_succ.call(null,data__20515__auto__));
}));


/**
 * Lens for the `succ` field (successor of the scale, when combined) from a [[Scale]] record. See [[active-viz.scale/make-scale]].
 */
active_viz.scale.scale_succ = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.Scale,rec__20514__auto__);

return rec__20514__auto__.succ;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,data__20515__auto__),active_viz.scale.scale_domain_max.call(null,data__20515__auto__),active_viz.scale.scale_range_min.call(null,data__20515__auto__),active_viz.scale.scale_range_max.call(null,data__20515__auto__),active_viz.scale.scale_fun.call(null,data__20515__auto__),v__20516__auto__);
}));


/**
 * @interface
 */
active_viz.scale.ScaleFn = function(){};

active_viz.scale.call = (function active_viz$scale$call(this$,scale,param){
if(((!((this$ == null))) && (!((this$.active_viz$scale$ScaleFn$call$arity$3 == null))))){
return this$.active_viz$scale$ScaleFn$call$arity$3(this$,scale,param);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (active_viz.scale.call[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,this$,scale,param);
} else {
var m__4244__auto____$1 = (active_viz.scale.call["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,this$,scale,param);
} else {
throw cljs.core.missing_protocol.call(null,"ScaleFn.call",this$);
}
}
}
});

active_viz.scale.call_inverse = (function active_viz$scale$call_inverse(this$,scale,param){
if(((!((this$ == null))) && (!((this$.active_viz$scale$ScaleFn$call_inverse$arity$3 == null))))){
return this$.active_viz$scale$ScaleFn$call_inverse$arity$3(this$,scale,param);
} else {
var x__4243__auto__ = (((this$ == null))?null:this$);
var m__4244__auto__ = (active_viz.scale.call_inverse[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,this$,scale,param);
} else {
var m__4244__auto____$1 = (active_viz.scale.call_inverse["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,this$,scale,param);
} else {
throw cljs.core.missing_protocol.call(null,"ScaleFn.call-inverse",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.Nop = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.Nop.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.Nop.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k21492,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__21496 = k21492;
switch (G__21496) {
default:
return cljs.core.get.call(null,self__.__extmap,k21492,else__4206__auto__);

}
});

active_viz.scale.Nop.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.Nop{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

active_viz.scale.Nop.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21491){
var self__ = this;
var G__21491__$1 = this;
return (new cljs.core.RecordIter((0),G__21491__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.Nop.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.Nop.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.Nop(self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.Nop.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (0 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.Nop.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (1070420063 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.Nop.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21493,other21494){
var self__ = this;
var this21493__$1 = this;
return ((!((other21494 == null))) && ((this21493__$1.constructor === other21494.constructor)) && (cljs.core._EQ_.call(null,this21493__$1.__extmap,other21494.__extmap)));
});

active_viz.scale.Nop.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,cljs.core.PersistentHashSet.EMPTY,k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.Nop(self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.Nop.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__21491){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__21497 = cljs.core.keyword_identical_QMARK_;
var expr__21498 = k__4211__auto__;
return (new active_viz.scale.Nop(self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__21491),null));
});

active_viz.scale.Nop.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

active_viz.scale.Nop.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__21491){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.Nop(G__21491,self__.__extmap,self__.__hash));
});

active_viz.scale.Nop.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.Nop.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

active_viz.scale.Nop.cljs$lang$type = true;

active_viz.scale.Nop.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale/Nop",null,(1),null));
});

active_viz.scale.Nop.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale/Nop");
});

/**
 * Positional factory function for active-viz.scale/Nop.
 */
active_viz.scale.__GT_Nop = (function active_viz$scale$__GT_Nop(){
return (new active_viz.scale.Nop(null,null,null));
});

/**
 * Factory function for active-viz.scale/Nop, taking a map of keywords to field values.
 */
active_viz.scale.map__GT_Nop = (function active_viz$scale$map__GT_Nop(G__21495){
var extmap__4236__auto__ = (function (){var G__21500 = cljs.core.dissoc.call(null,G__21495);
if(cljs.core.record_QMARK_.call(null,G__21495)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21500);
} else {
return G__21500;
}
})();
return (new active_viz.scale.Nop(null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `Nop` record? See [[active-viz.scale/make-nop]].
 */
active_viz.scale.nop_QMARK_ = (function active_viz$scale$nop_QMARK_(x__20517__auto__){
return (x__20517__auto__ instanceof active_viz.scale.Nop);
});

/**
 * Construct a `Nop` record.
 */
active_viz.scale.make_nop = (function active_viz$scale$make_nop(){
return (new active_viz.scale.Nop(null,null,null));
});

active_viz.scale.nop = active_viz.scale.make_nop.call(null);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {active_viz.scale.ScaleFn}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.InvertingScaleFun = (function (min_PLUS_max,__meta,__extmap,__hash){
this.min_PLUS_max = min_PLUS_max;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.InvertingScaleFun.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k21503,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__21507 = k21503;
var G__21507__$1 = (((G__21507 instanceof cljs.core.Keyword))?G__21507.fqn:null);
switch (G__21507__$1) {
case "min+max":
return self__.min_PLUS_max;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21503,else__4206__auto__);

}
});

active_viz.scale.InvertingScaleFun.prototype.active_viz$scale$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.InvertingScaleFun.prototype.active_viz$scale$ScaleFn$call$arity$3 = (function (this$,_,param){
var self__ = this;
var this$__$1 = this;
return (active_viz.scale.inverting_scale_fun_min_PLUS_max.call(null,this$__$1) - param);
});

active_viz.scale.InvertingScaleFun.prototype.active_viz$scale$ScaleFn$call_inverse$arity$3 = (function (this$,s,param){
var self__ = this;
var this$__$1 = this;
return this$__$1.active_viz$scale$ScaleFn$call$arity$3(null,s,param);
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.InvertingScaleFun{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"min+max","min+max",327927461),self__.min_PLUS_max],null))], null),self__.__extmap));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21502){
var self__ = this;
var G__21502__$1 = this;
return (new cljs.core.RecordIter((0),G__21502__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"min+max","min+max",327927461)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.InvertingScaleFun(self__.min_PLUS_max,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (809960746 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21504,other21505){
var self__ = this;
var this21504__$1 = this;
return ((!((other21505 == null))) && ((this21504__$1.constructor === other21505.constructor)) && (cljs.core._EQ_.call(null,this21504__$1.min_PLUS_max,other21505.min_PLUS_max)) && (cljs.core._EQ_.call(null,this21504__$1.__extmap,other21505.__extmap)));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"min+max","min+max",327927461),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.InvertingScaleFun(self__.min_PLUS_max,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__21502){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__21508 = cljs.core.keyword_identical_QMARK_;
var expr__21509 = k__4211__auto__;
if(cljs.core.truth_(pred__21508.call(null,new cljs.core.Keyword(null,"min+max","min+max",327927461),expr__21509))){
return (new active_viz.scale.InvertingScaleFun(G__21502,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.InvertingScaleFun(self__.min_PLUS_max,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__21502),null));
}
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"min+max","min+max",327927461),self__.min_PLUS_max,null))], null),self__.__extmap));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__21502){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.InvertingScaleFun(self__.min_PLUS_max,G__21502,self__.__extmap,self__.__hash));
});

active_viz.scale.InvertingScaleFun.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.InvertingScaleFun.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"min+max","min+max",1968458988,null)], null);
});

active_viz.scale.InvertingScaleFun.cljs$lang$type = true;

active_viz.scale.InvertingScaleFun.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale/InvertingScaleFun",null,(1),null));
});

active_viz.scale.InvertingScaleFun.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale/InvertingScaleFun");
});

/**
 * Positional factory function for active-viz.scale/InvertingScaleFun.
 */
active_viz.scale.__GT_InvertingScaleFun = (function active_viz$scale$__GT_InvertingScaleFun(min_PLUS_max){
return (new active_viz.scale.InvertingScaleFun(min_PLUS_max,null,null,null));
});

/**
 * Factory function for active-viz.scale/InvertingScaleFun, taking a map of keywords to field values.
 */
active_viz.scale.map__GT_InvertingScaleFun = (function active_viz$scale$map__GT_InvertingScaleFun(G__21506){
var extmap__4236__auto__ = (function (){var G__21511 = cljs.core.dissoc.call(null,G__21506,new cljs.core.Keyword(null,"min+max","min+max",327927461));
if(cljs.core.record_QMARK_.call(null,G__21506)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21511);
} else {
return G__21511;
}
})();
return (new active_viz.scale.InvertingScaleFun(new cljs.core.Keyword(null,"min+max","min+max",327927461).cljs$core$IFn$_invoke$arity$1(G__21506),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `InvertingScaleFun` record? See [[active-viz.scale/make-inverting-scale-fun]].
 */
active_viz.scale.inverting_scale_fun_QMARK_ = (function active_viz$scale$inverting_scale_fun_QMARK_(x__20517__auto__){
return (x__20517__auto__ instanceof active_viz.scale.InvertingScaleFun);
});

/**
 * Construct a `InvertingScaleFun` record.
 * 
 * `min+max`: access via [[active-viz.scale/inverting-scale-fun-min+max]]
 */
active_viz.scale.make_inverting_scale_fun = (function active_viz$scale$make_inverting_scale_fun(min_PLUS_max){
return (new active_viz.scale.InvertingScaleFun(min_PLUS_max,null,null,null));
});


/**
 * Lens for the `min+max` field from a [[InvertingScaleFun]] record. See [[active-viz.scale/make-inverting-scale-fun]].
 */
active_viz.scale.inverting_scale_fun_min_PLUS_max = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.InvertingScaleFun,rec__20514__auto__);

return rec__20514__auto__.min_PLUS_max;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_inverting_scale_fun.call(null,v__20516__auto__);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {active_viz.scale.ScaleFn}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.PaddingScaleFun = (function (padding,__meta,__extmap,__hash){
this.padding = padding;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.PaddingScaleFun.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k21514,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__21518 = k21514;
var G__21518__$1 = (((G__21518 instanceof cljs.core.Keyword))?G__21518.fqn:null);
switch (G__21518__$1) {
case "padding":
return self__.padding;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21514,else__4206__auto__);

}
});

active_viz.scale.PaddingScaleFun.prototype.active_viz$scale$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.PaddingScaleFun.prototype.active_viz$scale$ScaleFn$call$arity$3 = (function (this$,_,param){
var self__ = this;
var this$__$1 = this;
return (param + active_viz.scale.padding_scale_fun_padding.call(null,this$__$1));
});

active_viz.scale.PaddingScaleFun.prototype.active_viz$scale$ScaleFn$call_inverse$arity$3 = (function (this$,_,param){
var self__ = this;
var this$__$1 = this;
return (param - active_viz.scale.padding_scale_fun_padding.call(null,this$__$1));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active-viz.scale.PaddingScaleFun{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding","padding",1660304693),self__.padding],null))], null),self__.__extmap));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21513){
var self__ = this;
var G__21513__$1 = this;
return (new cljs.core.RecordIter((0),G__21513__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"padding","padding",1660304693)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active_viz.scale.PaddingScaleFun(self__.padding,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-653123206 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21515,other21516){
var self__ = this;
var this21515__$1 = this;
return ((!((other21516 == null))) && ((this21515__$1.constructor === other21516.constructor)) && (cljs.core._EQ_.call(null,this21515__$1.padding,other21516.padding)) && (cljs.core._EQ_.call(null,this21515__$1.__extmap,other21516.__extmap)));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active_viz.scale.PaddingScaleFun(self__.padding,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__21513){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__21519 = cljs.core.keyword_identical_QMARK_;
var expr__21520 = k__4211__auto__;
if(cljs.core.truth_(pred__21519.call(null,new cljs.core.Keyword(null,"padding","padding",1660304693),expr__21520))){
return (new active_viz.scale.PaddingScaleFun(G__21513,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.PaddingScaleFun(self__.padding,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__21513),null));
}
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding","padding",1660304693),self__.padding,null))], null),self__.__extmap));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__21513){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active_viz.scale.PaddingScaleFun(self__.padding,G__21513,self__.__extmap,self__.__hash));
});

active_viz.scale.PaddingScaleFun.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active_viz.scale.PaddingScaleFun.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"padding","padding",-994131076,null)], null);
});

active_viz.scale.PaddingScaleFun.cljs$lang$type = true;

active_viz.scale.PaddingScaleFun.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active-viz.scale/PaddingScaleFun",null,(1),null));
});

active_viz.scale.PaddingScaleFun.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active-viz.scale/PaddingScaleFun");
});

/**
 * Positional factory function for active-viz.scale/PaddingScaleFun.
 */
active_viz.scale.__GT_PaddingScaleFun = (function active_viz$scale$__GT_PaddingScaleFun(padding){
return (new active_viz.scale.PaddingScaleFun(padding,null,null,null));
});

/**
 * Factory function for active-viz.scale/PaddingScaleFun, taking a map of keywords to field values.
 */
active_viz.scale.map__GT_PaddingScaleFun = (function active_viz$scale$map__GT_PaddingScaleFun(G__21517){
var extmap__4236__auto__ = (function (){var G__21522 = cljs.core.dissoc.call(null,G__21517,new cljs.core.Keyword(null,"padding","padding",1660304693));
if(cljs.core.record_QMARK_.call(null,G__21517)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21522);
} else {
return G__21522;
}
})();
return (new active_viz.scale.PaddingScaleFun(new cljs.core.Keyword(null,"padding","padding",1660304693).cljs$core$IFn$_invoke$arity$1(G__21517),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
 * Is object a `PaddingScaleFun` record? See [[active-viz.scale/make-padding-scale-fun]].
 */
active_viz.scale.padding_scale_fun_QMARK_ = (function active_viz$scale$padding_scale_fun_QMARK_(x__20517__auto__){
return (x__20517__auto__ instanceof active_viz.scale.PaddingScaleFun);
});

/**
 * Construct a `PaddingScaleFun` record.
 * 
 * `padding`: access via [[active-viz.scale/padding-scale-fun-padding]]
 */
active_viz.scale.make_padding_scale_fun = (function active_viz$scale$make_padding_scale_fun(padding){
return (new active_viz.scale.PaddingScaleFun(padding,null,null,null));
});


/**
 * Lens for the `padding` field from a [[PaddingScaleFun]] record. See [[active-viz.scale/make-padding-scale-fun]].
 */
active_viz.scale.padding_scale_fun_padding = active.clojure.lens.lens.call(null,(function (rec__20514__auto__){
active.clojure.record.check_type.call(null,active_viz.scale.PaddingScaleFun,rec__20514__auto__);

return rec__20514__auto__.padding;
}),(function (data__20515__auto__,v__20516__auto__){
return active_viz.scale.make_padding_scale_fun.call(null,v__20516__auto__);
}));

active_viz.scale.scale = (function active_viz$scale$scale(scale,param){
var s = scale;
var p = param;
while(true){
if(cljs.core.truth_(active_viz.scale.nop_QMARK_.call(null,s))){
return p;
} else {
var scale_fun = active_viz.scale.scale_fun.call(null,s);
var G__21524 = active_viz.scale.scale_succ.call(null,s);
var G__21525 = active_viz.scale.call.call(null,scale_fun,scale,p);
s = G__21524;
p = G__21525;
continue;
}
break;
}
});
active_viz.scale.collect_scales_reversed = (function active_viz$scale$collect_scales_reversed(scale){
var s = scale;
var acc = cljs.core.List.EMPTY;
while(true){
if(cljs.core.truth_(active_viz.scale.nop_QMARK_.call(null,active_viz.scale.scale_fun.call(null,s)))){
return acc;
} else {
var G__21526 = active_viz.scale.scale_succ.call(null,s);
var G__21527 = cljs.core.cons.call(null,s,acc);
s = G__21526;
acc = G__21527;
continue;
}
break;
}
});
active_viz.scale.scale_inverted = (function active_viz$scale$scale_inverted(scale,param){
return cljs.core.reduce.call(null,(function (param_SINGLEQUOTE_,s){
return active_viz.scale.call_inverse.call(null,active_viz.scale.scale_fun.call(null,s),s,param_SINGLEQUOTE_);
}),param,active_viz.scale.collect_scales_reversed.call(null,scale));
});
active_viz.scale.shove_succ = (function active_viz$scale$shove_succ(scale,succ){
var current_succ = active_viz.scale.scale_succ.call(null,scale);
cljs.core.println.call(null,cljs.core.pr_str.call(null,active_viz.scale.scale_succ));

if(cljs.core.truth_(active_viz.scale.nop_QMARK_.call(null,current_succ))){
return active.clojure.lens.shove.call(null,scale,active_viz.scale.scale_succ,succ);
} else {
return active.clojure.lens.shove.call(null,scale,active_viz.scale.scale_succ,active_viz.scale.shove_succ.call(null,current_succ,succ));
}
});
/**
 * Inverts the range of a scaling, including the invertion of the scale-fn, for the specified range.
 *   This is done by calculating the center of this range and mirroring target values.
 */
active_viz.scale._GT__GT_ = (function active_viz$scale$_GT__GT_(scale1,scale2){
cljs.core.println.call(null,"-");

var rmin_2 = active_viz.scale.scale_range_min.call(null,scale2);
var rmax_2 = active_viz.scale.scale_range_max.call(null,scale2);
return active.clojure.lens.shove.call(null,active.clojure.lens.shove.call(null,active_viz.scale.shove_succ.call(null,scale1,scale2),active_viz.scale.scale_range_min,rmin_2),active_viz.scale.scale_range_max,rmax_2);
});
/**
 * Inverts the range of a scaling, including the invertion of the scale-fn, for the specified range.
 *   This is done by calculating the center of this range and mirroring target values.
 */
active_viz.scale.invert_scale = (function active_viz$scale$invert_scale(scale){
var min = active_viz.scale.scale_range_min.call(null,scale);
var max = active_viz.scale.scale_range_max.call(null,scale);
var min_PLUS_max = (min + max);
var inverting_scale = active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,scale),active_viz.scale.scale_domain_max.call(null,scale),min,max,active_viz.scale.make_inverting_scale_fun.call(null,min_PLUS_max),active_viz.scale.nop);
return active_viz.scale._GT__GT_.call(null,scale,inverting_scale);
});
/**
 * Pads a scale in the sense of adding a offset defined in `padding` to the target range.
 */
active_viz.scale.pad_scale = (function active_viz$scale$pad_scale(scale,padding){
var prev_min = active_viz.scale.scale_range_min.call(null,scale);
var prev_max = active_viz.scale.scale_range_max.call(null,scale);
var min = (prev_min + padding);
var max = (prev_max + padding);
var padding_scale = active_viz.scale.make_scale.call(null,active_viz.scale.scale_domain_min.call(null,scale),active_viz.scale.scale_domain_max.call(null,scale),min,max,active_viz.scale.make_padding_scale_fun.call(null,padding),active_viz.scale.nop);
return active_viz.scale._GT__GT_.call(null,scale,padding_scale);
});
active_viz.scale.pad_scale_to_zero = (function active_viz$scale$pad_scale_to_zero(scale){
var negate = (function active_viz$scale$pad_scale_to_zero_$_negate(v){
return ((-1) * v);
});
return active_viz.scale.pad_scale.call(null,scale,negate.call(null,(function (){var x__4040__auto__ = active_viz.scale.scale_range_min.call(null,scale);
var y__4041__auto__ = active_viz.scale.scale_range_max.call(null,scale);
return ((x__4040__auto__ < y__4041__auto__) ? x__4040__auto__ : y__4041__auto__);
})()));
});

//# sourceMappingURL=scale.js.map
