// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.linear_scale');
goog.require('cljs.core');
goog.require('active_viz.ticks');
goog.require('active.clojure.cljs.record');
goog.require('active_viz.scale.types');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.linear_scale.LinearScaleParams = (function (a,b,__meta,__extmap,__hash){
this.a = a;
this.b = b;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__9016__auto__,k__9017__auto__){
var self__ = this;
var this__9016__auto____$1 = this;
return this__9016__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__9017__auto__,null);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__9018__auto__,k9195,else__9019__auto__){
var self__ = this;
var this__9018__auto____$1 = this;
var G__9199 = k9195;
var G__9199__$1 = (((G__9199 instanceof cljs.core.Keyword))?G__9199.fqn:null);
switch (G__9199__$1) {
case "a":
return self__.a;

break;
case "b":
return self__.b;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k9195,else__9019__auto__);

}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__9026__auto__,writer__9027__auto__,opts__9028__auto__){
var self__ = this;
var this__9026__auto____$1 = this;
var pr_pair__9029__auto__ = ((function (this__9026__auto____$1){
return (function (keyval__9030__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__9027__auto__,cljs.core.pr_writer,""," ","",opts__9028__auto__,keyval__9030__auto__);
});})(this__9026__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__9027__auto__,pr_pair__9029__auto__,"#active-viz.scale.linear-scale.LinearScaleParams{",", ","}",opts__9028__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"a","a",-2123407586),self__.a],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"b","b",1482224470),self__.b],null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__9194){
var self__ = this;
var G__9194__$1 = this;
return (new cljs.core.RecordIter((0),G__9194__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__9014__auto__){
var self__ = this;
var this__9014__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__9011__auto__){
var self__ = this;
var this__9011__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__9020__auto__){
var self__ = this;
var this__9020__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__9012__auto__){
var self__ = this;
var this__9012__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__9012__auto____$1){
return (function (coll__9013__auto__){
return (-1801074233 ^ cljs.core.hash_unordered_coll.call(null,coll__9013__auto__));
});})(h__4061__auto__,this__9012__auto____$1))
.call(null,this__9012__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this9196,other9197){
var self__ = this;
var this9196__$1 = this;
return ((!((other9197 == null))) && ((this9196__$1.constructor === other9197.constructor)) && (cljs.core._EQ_.call(null,this9196__$1.a,other9197.a)) && (cljs.core._EQ_.call(null,this9196__$1.b,other9197.b)) && (cljs.core._EQ_.call(null,this9196__$1.__extmap,other9197.__extmap)));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param * self__.a) + self__.b);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return ((param - self__.b) / self__.a);
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__9009__auto__,k__9010__auto__){
var self__ = this;
var this__9009__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"b","b",1482224470),null,new cljs.core.Keyword(null,"a","a",-2123407586),null], null), null),k__9010__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__9009__auto____$1),self__.__meta),k__9010__auto__);
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__9010__auto__)),null));
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__9007__auto__,k__9008__auto__,G__9194){
var self__ = this;
var this__9007__auto____$1 = this;
var pred__9200 = cljs.core.keyword_identical_QMARK_;
var expr__9201 = k__9008__auto__;
if(cljs.core.truth_(pred__9200.call(null,new cljs.core.Keyword(null,"a","a",-2123407586),expr__9201))){
return (new active_viz.scale.linear_scale.LinearScaleParams(G__9194,self__.b,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__9200.call(null,new cljs.core.Keyword(null,"b","b",1482224470),expr__9201))){
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,G__9194,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__9008__auto__,G__9194),null));
}
}
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__9024__auto__){
var self__ = this;
var this__9024__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"a","a",-2123407586),self__.a],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"b","b",1482224470),self__.b],null))], null),self__.__extmap));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__9015__auto__,G__9194){
var self__ = this;
var this__9015__auto____$1 = this;
return (new active_viz.scale.linear_scale.LinearScaleParams(self__.a,self__.b,G__9194,self__.__extmap,self__.__hash));
});

active_viz.scale.linear_scale.LinearScaleParams.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__9021__auto__,entry__9022__auto__){
var self__ = this;
var this__9021__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__9022__auto__)){
return this__9021__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__9022__auto__,(0)),cljs.core._nth.call(null,entry__9022__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__9021__auto____$1,entry__9022__auto__);
}
});

active_viz.scale.linear_scale.LinearScaleParams.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null);
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$type = true;

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrSeq = (function (this__9102__auto__){
return (new cljs.core.List(null,"active-viz.scale.linear-scale/LinearScaleParams",null,(1),null));
});

active_viz.scale.linear_scale.LinearScaleParams.cljs$lang$ctorPrWriter = (function (this__9102__auto__,writer__9103__auto__){
return cljs.core._write.call(null,writer__9103__auto__,"active-viz.scale.linear-scale/LinearScaleParams");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
active_viz.scale.linear_scale.__GT_LinearScaleParams = (function active_viz$scale$linear_scale$__GT_LinearScaleParams(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});
}

active_viz.scale.linear_scale.map__GT_LinearScaleParams = (function active_viz$scale$linear_scale$map__GT_LinearScaleParams(G__9198){
return (new active_viz.scale.linear_scale.LinearScaleParams(new cljs.core.Keyword(null,"a","a",-2123407586).cljs$core$IFn$_invoke$arity$1(G__9198),new cljs.core.Keyword(null,"b","b",1482224470).cljs$core$IFn$_invoke$arity$1(G__9198),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__9198,new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470))),null));
});

/**
 * Is object a `LinearScaleParams` record? See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_params_QMARK_ = (function active_viz$scale$linear_scale$linear_scale_params_QMARK_(x__9104__auto__){
return (x__9104__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams);
});

/**
 * Construct a `LinearScaleParams` record.
 * 
 * `a`: access via [[active-viz.scale.linear-scale/linear-scale-a]]
 * `b`: access via [[active-viz.scale.linear-scale/linear-scale-b]]
 */
active_viz.scale.linear_scale.make_linear_scale_params = (function active_viz$scale$linear_scale$make_linear_scale_params(a,b){
return (new active_viz.scale.linear_scale.LinearScaleParams(a,b,null,null,null));
});



/**
 * Lens for the `a` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_a = active.clojure.lens.lens.call(null,(function (rec__9083__auto__){
if((rec__9083__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams)){
} else {
throw (new Error("Wrong record type (rec__9083__auto__) passed to accessor (linear-scale-a)."));
}

return rec__9083__auto__.a;
}),(function (data__9084__auto__,v__9085__auto__){
return (new active_viz.scale.linear_scale.LinearScaleParams(v__9085__auto__,active_viz.scale.linear_scale.linear_scale_b.call(null,data__9084__auto__),null,null,null));
}));


/**
 * Lens for the `b` field from a [[LinearScaleParams]] record. See [[active-viz.scale.linear-scale/make-linear-scale-params]].
 */
active_viz.scale.linear_scale.linear_scale_b = active.clojure.lens.lens.call(null,(function (rec__9083__auto__){
if((rec__9083__auto__ instanceof active_viz.scale.linear_scale.LinearScaleParams)){
} else {
throw (new Error("Wrong record type (rec__9083__auto__) passed to accessor (linear-scale-b)."));
}

return rec__9083__auto__.b;
}),(function (data__9084__auto__,v__9085__auto__){
return (new active_viz.scale.linear_scale.LinearScaleParams(active_viz.scale.linear_scale.linear_scale_a.call(null,data__9084__auto__),v__9085__auto__,null,null,null));
}));



active_viz.scale.linear_scale.make_linear_scale = (function active_viz$scale$linear_scale$make_linear_scale(p__9204,p__9205){
var vec__9206 = p__9204;
var domain_min = cljs.core.nth.call(null,vec__9206,(0),null);
var domain_max = cljs.core.nth.call(null,vec__9206,(1),null);
var vec__9209 = p__9205;
var range_min = cljs.core.nth.call(null,vec__9209,(0),null);
var range_max = cljs.core.nth.call(null,vec__9209,(1),null);
var domain_spread = (domain_max - domain_min);
var range_spread = (range_max - range_min);
var a = (range_spread / domain_spread);
var b = (range_min - (domain_min * a));
return active_viz.scale.types.make_scale.call(null,domain_min,domain_max,range_min,range_max,active_viz.scale.linear_scale.make_linear_scale_params.call(null,a,b),active_viz.scale.types.nop);
});
active_viz.scale.linear_scale.to_ticks = (function active_viz$scale$linear_scale$to_ticks(p__9212){
var map__9213 = p__9212;
var map__9213__$1 = ((((!((map__9213 == null)))?(((((map__9213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9213.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9213):map__9213);
var lstep = cljs.core.get.call(null,map__9213__$1,new cljs.core.Keyword(null,"lstep","lstep",-1243990033));
var lmin = cljs.core.get.call(null,map__9213__$1,new cljs.core.Keyword(null,"lmin","lmin",2139111947));
var lmax = cljs.core.get.call(null,map__9213__$1,new cljs.core.Keyword(null,"lmax","lmax",-1390660950));
var current = lmin;
var acc = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lmin], null);
while(true){
var next = (lstep + cljs.core.first.call(null,acc));
if((next > lmax)){
return acc;
} else {
var G__9215 = next;
var G__9216 = cljs.core.cons.call(null,next,acc);
current = G__9215;
acc = G__9216;
continue;
}
break;
}
});
active_viz.scale.linear_scale.ticks = (function active_viz$scale$linear_scale$ticks(domain_min,domain_max,num_ticks){
var G__9217 = active_viz.ticks.nice_ticks.call(null,domain_min,domain_max,num_ticks);
if((G__9217 == null)){
return null;
} else {
return active_viz.scale.linear_scale.to_ticks.call(null,G__9217);
}
});
active_viz.scale.linear_scale.linear_scale__GT_ticks = (function active_viz$scale$linear_scale$linear_scale__GT_ticks(scale,num_ticks){
return active_viz.scale.linear_scale.ticks.call(null,active_viz.scale.types.scale_domain_min.call(null,scale),active_viz.scale.types.scale_domain_max.call(null,scale),num_ticks);
});

//# sourceMappingURL=linear_scale.js.map
