// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale_test');
goog.require('cljs.core');
goog.require('active_viz.scale');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('cljs_time.core');
goog.require('cljs.test');
active_viz.scale_test.eps = 1.0E-5;
active_viz.scale_test.eq = (function active_viz$scale_test$eq(a,b){
return ((((b + active_viz.scale_test.eps) > a)) && (((b - active_viz.scale_test.eps) < a)));
});
active_viz.scale_test.scale = (function active_viz$scale_test$scale(){
return cljs.test.test_var.call(null,active_viz.scale_test.scale.cljs$lang$var);
});
active_viz.scale_test.scale.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"combines two scales properly");

try{var start_date_9759 = cljs_time.core.date_time.call(null,(2018),(1),(1),(0),(0),(0),(0));
var end_date_9760 = cljs_time.core.date_time.call(null,(2019),(1),(1),(0),(0),(0),(0));
var time_scale_9761 = active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_9759,end_date_9760], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null));
var linear_scale_9762 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1000)], null));
var combined_scale_9763 = active_viz.scale._GT__GT_.call(null,time_scale_9761,linear_scale_9762);
try{var values__9392__auto___9764 = (new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9763,start_date_9759),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9765 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9764);
if(cljs.core.truth_(result__9393__auto___9765)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9764),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9764),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9736){var t__9437__auto___9766 = e9736;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9766,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9767 = (new cljs.core.List(null,(1000),(new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9763,end_date_9760),null,(1),null)),(2),null));
var result__9393__auto___9768 = cljs.core.apply.call(null,active_viz.scale_test.eq,values__9392__auto___9767);
if(cljs.core.truth_(result__9393__auto___9768)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,active_viz.scale_test.eq,values__9392__auto___9767),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"eq","eq",1021992460,null),values__9392__auto___9767),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9737){var t__9437__auto___9769 = e9737;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9769,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"inverts a scale range");

try{var linear_scale_9770 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var inverted_9771 = active_viz.scale.invert.call(null,linear_scale_9770);
var orig_9772 = active_viz.scale.invert.call(null,inverted_9771);
try{var values__9392__auto___9773 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9771,(0)),(new cljs.core.List(null,(200),null,(1),null)),(2),null));
var result__9393__auto___9774 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9773);
if(cljs.core.truth_(result__9393__auto___9774)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9773),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9773),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9738){var t__9437__auto___9775 = e9738;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9775,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9776 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9771,(50)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9393__auto___9777 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9776);
if(cljs.core.truth_(result__9393__auto___9777)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9776),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9776),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9739){var t__9437__auto___9778 = e9739;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9778,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9779 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9771,(100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9780 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9779);
if(cljs.core.truth_(result__9393__auto___9780)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9779),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9779),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9740){var t__9437__auto___9781 = e9740;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9781,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9782 = (new cljs.core.List(null,active_viz.scale.scale.call(null,linear_scale_9770,(25)),(new cljs.core.List(null,active_viz.scale.scale.call(null,orig_9772,(25)),null,(1),null)),(2),null));
var result__9393__auto___9783 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9782);
if(cljs.core.truth_(result__9393__auto___9783)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9782),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9782),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9741){var t__9437__auto___9784 = e9741;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9784,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9785 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9771,(0)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9393__auto___9786 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9785);
if(cljs.core.truth_(result__9393__auto___9786)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9785),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9785),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9742){var t__9437__auto___9787 = e9742;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9787,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9788 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9771,(100)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9393__auto___9789 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9788);
if(cljs.core.truth_(result__9393__auto___9789)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9788),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9788),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9743){var t__9437__auto___9790 = e9743;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9790,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9791 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9771,(200)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9792 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9791);
if(cljs.core.truth_(result__9393__auto___9792)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9791),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9791),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9744){var t__9437__auto___9793 = e9744;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9793,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale");

try{var scale_9794 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var pad_scale_9795 = active_viz.scale.pad.call(null,scale_9794,(50));
try{var values__9392__auto___9796 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9795,(0)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9393__auto___9797 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9796);
if(cljs.core.truth_(result__9393__auto___9797)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9796),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9796),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9745){var t__9437__auto___9798 = e9745;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9798,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9799 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9795,(50)),(new cljs.core.List(null,(150),null,(1),null)),(2),null));
var result__9393__auto___9800 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9799);
if(cljs.core.truth_(result__9393__auto___9800)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9799),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9799),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9746){var t__9437__auto___9801 = e9746;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9801,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9802 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9795,(100)),(new cljs.core.List(null,(250),null,(1),null)),(2),null));
var result__9393__auto___9803 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9802);
if(cljs.core.truth_(result__9393__auto___9803)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9802),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9802),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9747){var t__9437__auto___9804 = e9747;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9804,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9805 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9795,(50)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9806 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9805);
if(cljs.core.truth_(result__9393__auto___9806)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9805),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9805),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9748){var t__9437__auto___9807 = e9748;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9807,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9808 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9795,(150)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9393__auto___9809 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9808);
if(cljs.core.truth_(result__9393__auto___9809)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9808),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9808),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9749){var t__9437__auto___9810 = e9749;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9810,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9811 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9795,(250)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9393__auto___9812 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9811);
if(cljs.core.truth_(result__9393__auto___9812)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9811),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9811),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9750){var t__9437__auto___9813 = e9750;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9813,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale to zero");

try{var neg_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-200),(200)], null));
var pad_scale = active_viz.scale.pad_to_zero.call(null,neg_scale);
var pos_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(600)], null));
var pad_scale_2 = active_viz.scale.pad_to_zero.call(null,pos_scale);
try{var values__9392__auto___9814 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9815 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9814);
if(cljs.core.truth_(result__9393__auto___9815)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9814),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9814),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9751){var t__9437__auto___9816 = e9751;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9816,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9817 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__9393__auto___9818 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9817);
if(cljs.core.truth_(result__9393__auto___9818)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9817),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9817),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9752){var t__9437__auto___9819 = e9752;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9819,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9820 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9393__auto___9821 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9820);
if(cljs.core.truth_(result__9393__auto___9821)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9820),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9820),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9753){var t__9437__auto___9822 = e9753;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9822,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9823 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__9393__auto___9824 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9823);
if(cljs.core.truth_(result__9393__auto___9824)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9823),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9823),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9754){var t__9437__auto___9825 = e9754;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9825,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9826 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__9393__auto___9827 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9826);
if(cljs.core.truth_(result__9393__auto___9827)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9826),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9826),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9755){var t__9437__auto___9828 = e9755;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9828,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9829 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9393__auto___9830 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9829);
if(cljs.core.truth_(result__9393__auto___9830)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9829),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9829),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9756){var t__9437__auto___9831 = e9756;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9831,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto___9832 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__9393__auto___9833 = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto___9832);
if(cljs.core.truth_(result__9393__auto___9833)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto___9832),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto___9832),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9757){var t__9437__auto___9834 = e9757;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto___9834,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9392__auto__ = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9393__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__9392__auto__);
if(cljs.core.truth_(result__9393__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9392__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9392__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__9393__auto__;
}catch (e9758){var t__9437__auto__ = e9758;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9437__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

active_viz.scale_test.scale.cljs$lang$var = new cljs.core.Var(function(){return active_viz.scale_test.scale;},new cljs.core.Symbol("active-viz.scale-test","scale","active-viz.scale-test/scale",1189529197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"active-viz.scale-test","active-viz.scale-test",-1253028839,null),new cljs.core.Symbol(null,"scale","scale",1410104174,null),"/home/simon/git/active-viz/test/active_viz/scale_test.cljs",15,1,16,16,cljs.core.List.EMPTY,null,(cljs.core.truth_(active_viz.scale_test.scale)?active_viz.scale_test.scale.cljs$lang$test:null)]));

//# sourceMappingURL=scale_test.js.map
