// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale_test');
goog.require('cljs.core');
goog.require('active_viz.scale');
goog.require('active_viz.scale.linear_scale');
goog.require('active_viz.scale.time_scale');
goog.require('cljs_time.core');
goog.require('cljs.test');
active_viz.scale_test.eps = 1.0E-5;
active_viz.scale_test.eq = (function active_viz$scale_test$eq(a,b){
return ((((b + active_viz.scale_test.eps) > a)) && (((b - active_viz.scale_test.eps) < a)));
});
active_viz.scale_test.scale = (function active_viz$scale_test$scale(){
return cljs.test.test_var.call(null,active_viz.scale_test.scale.cljs$lang$var);
});
active_viz.scale_test.scale.cljs$lang$test = (function (){
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"combines two scales properly");

try{var start_date_9787 = cljs_time.core.date_time.call(null,(2018),(1),(1),(0),(0),(0),(0));
var end_date_9788 = cljs_time.core.date_time.call(null,(2019),(1),(1),(0),(0),(0),(0));
var time_scale_9789 = active_viz.scale.time_scale.make_time_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_9787,end_date_9788], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null));
var linear_scale_9790 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(100),(246)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1000)], null));
var combined_scale_9791 = active_viz.scale._GT__GT_.call(null,time_scale_9789,linear_scale_9790);
try{var values__9420__auto___9792 = (new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9791,start_date_9787),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9793 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9792);
if(cljs.core.truth_(result__9421__auto___9793)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9792),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9792),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9764){var t__9465__auto___9794 = e9764;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"start-date","start-date",1935700258,null)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9794,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9795 = (new cljs.core.List(null,(1000),(new cljs.core.List(null,active_viz.scale.scale.call(null,combined_scale_9791,end_date_9788),null,(1),null)),(2),null));
var result__9421__auto___9796 = cljs.core.apply.call(null,active_viz.scale_test.eq,values__9420__auto___9795);
if(cljs.core.truth_(result__9421__auto___9796)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,active_viz.scale_test.eq,values__9420__auto___9795),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"eq","eq",1021992460,null),values__9420__auto___9795),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9765){var t__9465__auto___9797 = e9765;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"eq","eq",1021992460,null),(1000),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"combined-scale","combined-scale",-1463311509,null),new cljs.core.Symbol(null,"end-date","end-date",1432271885,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9797,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"inverts a scale range");

try{var linear_scale_9798 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var inverted_9799 = active_viz.scale.invert.call(null,linear_scale_9798);
var orig_9800 = active_viz.scale.invert.call(null,inverted_9799);
try{var values__9420__auto___9801 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9799,(0)),(new cljs.core.List(null,(200),null,(1),null)),(2),null));
var result__9421__auto___9802 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9801);
if(cljs.core.truth_(result__9421__auto___9802)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9801),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9801),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9766){var t__9465__auto___9803 = e9766;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(200)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9803,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9804 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9799,(50)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9421__auto___9805 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9804);
if(cljs.core.truth_(result__9421__auto___9805)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9804),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9804),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9767){var t__9465__auto___9806 = e9767;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(50)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9806,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9807 = (new cljs.core.List(null,active_viz.scale.scale.call(null,inverted_9799,(100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9808 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9807);
if(cljs.core.truth_(result__9421__auto___9808)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9807),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9807),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9768){var t__9465__auto___9809 = e9768;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9809,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9810 = (new cljs.core.List(null,active_viz.scale.scale.call(null,linear_scale_9798,(25)),(new cljs.core.List(null,active_viz.scale.scale.call(null,orig_9800,(25)),null,(1),null)),(2),null));
var result__9421__auto___9811 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9810);
if(cljs.core.truth_(result__9421__auto___9811)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9810),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9810),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9769){var t__9465__auto___9812 = e9769;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null),(25)),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"orig","orig",-37778343,null),(25))),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9812,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9813 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9799,(0)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9421__auto___9814 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9813);
if(cljs.core.truth_(result__9421__auto___9814)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9813),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9813),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9770){var t__9465__auto___9815 = e9770;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(0)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9815,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9816 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9799,(100)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9421__auto___9817 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9816);
if(cljs.core.truth_(result__9421__auto___9817)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9816),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9816),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9771){var t__9465__auto___9818 = e9771;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(100)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9818,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9819 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,inverted_9799,(200)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9820 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9819);
if(cljs.core.truth_(result__9421__auto___9820)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9819),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9819),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9772){var t__9465__auto___9821 = e9772;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"inverted","inverted",1329939237,null),(200)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9821,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale");

try{var scale_9822 = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(200)], null));
var pad_scale_9823 = active_viz.scale.pad.call(null,scale_9822,(50));
try{var values__9420__auto___9824 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9823,(0)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9421__auto___9825 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9824);
if(cljs.core.truth_(result__9421__auto___9825)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9824),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9824),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9773){var t__9465__auto___9826 = e9773;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9826,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9827 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9823,(50)),(new cljs.core.List(null,(150),null,(1),null)),(2),null));
var result__9421__auto___9828 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9827);
if(cljs.core.truth_(result__9421__auto___9828)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9827),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9827),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9774){var t__9465__auto___9829 = e9774;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(150)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9829,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9830 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_9823,(100)),(new cljs.core.List(null,(250),null,(1),null)),(2),null));
var result__9421__auto___9831 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9830);
if(cljs.core.truth_(result__9421__auto___9831)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9830),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9830),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9775){var t__9465__auto___9832 = e9775;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(250)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9832,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9833 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9823,(50)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9834 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9833);
if(cljs.core.truth_(result__9421__auto___9834)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9833),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9833),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9776){var t__9465__auto___9835 = e9776;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(50)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9835,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9836 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9823,(150)),(new cljs.core.List(null,(50),null,(1),null)),(2),null));
var result__9421__auto___9837 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9836);
if(cljs.core.truth_(result__9421__auto___9837)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9836),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9836),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9777){var t__9465__auto___9838 = e9777;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(150)),(50)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9838,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9839 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_9823,(250)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9421__auto___9840 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9839);
if(cljs.core.truth_(result__9421__auto___9840)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9839),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9839),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9778){var t__9465__auto___9841 = e9778;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(250)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9841,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,"pads a scale to zero");

try{var neg_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-200),(200)], null));
var pad_scale = active_viz.scale.pad_to_zero.call(null,neg_scale);
var pos_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-100),(100)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),(600)], null));
var pad_scale_2 = active_viz.scale.pad_to_zero.call(null,pos_scale);
try{var values__9420__auto___9842 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9843 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9842);
if(cljs.core.truth_(result__9421__auto___9843)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9842),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9842),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9779){var t__9465__auto___9844 = e9779;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9844,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9845 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__9421__auto___9846 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9845);
if(cljs.core.truth_(result__9421__auto___9846)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9845),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9845),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9780){var t__9465__auto___9847 = e9780;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9847,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9848 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(-100)),(new cljs.core.List(null,(0),null,(1),null)),(2),null));
var result__9421__auto___9849 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9848);
if(cljs.core.truth_(result__9421__auto___9849)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9848),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9848),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9781){var t__9465__auto___9850 = e9781;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(-100)),(0)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9850,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9851 = (new cljs.core.List(null,active_viz.scale.scale.call(null,pad_scale_2,(100)),(new cljs.core.List(null,(400),null,(1),null)),(2),null));
var result__9421__auto___9852 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9851);
if(cljs.core.truth_(result__9421__auto___9852)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9851),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9851),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9782){var t__9465__auto___9853 = e9782;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale","scale/scale",1586455076,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(100)),(400)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9853,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9854 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__9421__auto___9855 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9854);
if(cljs.core.truth_(result__9421__auto___9855)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9854),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9854),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9783){var t__9465__auto___9856 = e9783;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9856,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9857 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9421__auto___9858 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9857);
if(cljs.core.truth_(result__9421__auto___9858)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9857),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9857),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9784){var t__9465__auto___9859 = e9784;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale","pad-scale",1993369138,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9859,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto___9860 = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(0)),(new cljs.core.List(null,(-100),null,(1),null)),(2),null));
var result__9421__auto___9861 = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto___9860);
if(cljs.core.truth_(result__9421__auto___9861)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto___9860),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto___9860),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e9785){var t__9465__auto___9862 = e9785;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(0)),(-100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto___9862,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}
try{var values__9420__auto__ = (new cljs.core.List(null,active_viz.scale.scale_inverted.call(null,pad_scale_2,(400)),(new cljs.core.List(null,(100),null,(1),null)),(2),null));
var result__9421__auto__ = cljs.core.apply.call(null,cljs.core._EQ_,values__9420__auto__);
if(cljs.core.truth_(result__9421__auto__)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core._EQ_,values__9420__auto__),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),(new cljs.core.List(null,new cljs.core.Symbol(null,"not","not",1044554643,null),(new cljs.core.List(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"=","=",-1501502141,null),values__9420__auto__),null,(1),null)),(2),null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

return result__9421__auto__;
}catch (e9786){var t__9465__auto__ = e9786;
return cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),cljs.core.list(new cljs.core.Symbol("scale","scale-inverted","scale/scale-inverted",-1371195511,null),new cljs.core.Symbol(null,"pad-scale-2","pad-scale-2",1989468664,null),(400)),(100)),new cljs.core.Keyword(null,"actual","actual",107306363),t__9465__auto__,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}});

active_viz.scale_test.scale.cljs$lang$var = new cljs.core.Var(function(){return active_viz.scale_test.scale;},new cljs.core.Symbol("active-viz.scale-test","scale","active-viz.scale-test/scale",1189529197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"active-viz.scale-test","active-viz.scale-test",-1253028839,null),new cljs.core.Symbol(null,"scale","scale",1410104174,null),"/home/simon/git/active-viz/test/active_viz/scale_test.cljs",15,1,16,16,cljs.core.List.EMPTY,null,(cljs.core.truth_(active_viz.scale_test.scale)?active_viz.scale_test.scale.cljs$lang$test:null)]));

//# sourceMappingURL=scale_test.js.map
