(ns active-viz.canvas.core
  (:require [reacl2.core :as reacl :include-macros true]
            [reacl2.dom :as dom]
            [active.clojure.monad :as m :include-macros true]))

(reacl/defclass canvas-2d this [attrs f & args]
  local [curr-args [attrs f args]
         run! (fn [elem program]
                (two-d/run! (.-getContext elem "2d") program))]

  ;; TODO: sync/async onStartDrawing onFinishedDrawing max-draw-time.
  
  local-state [local-state {:last-args curr-args
                            :id nil}]

  refs [self]

  component-did-mount
  (fn []
    (if-let [elem (reacl/get-dom self)]
      (reacl/return :local-state (assoc local-state :id (run! elem (apply f args))))
      ;; Ok for testing:
      (reacl/return)))

  component-did-update
  (fn []
    (if (not= (:last-args local-state) curr-args)
      (do (cancel! (:id local-state))
          (if-let [elem (reacl/get-dom self)]
            (reacl/return :local-state (assoc local-state
                                              :last-args curr-args
                                              :id (run! elem (m/monadic
                                                              (two-d/clear-rect! 0 0 (.-width elem) (.-height elem))
                                                              (apply f args)))))
            ;; Ok for testing:
            (reacl/return)))
      (reacl/return)))

  component-will-unmount
  (fn []
    (cancel! (:id local-state))
    (reacl/return))
  
  render
  (-> (dom/canvas attrs)
      (reacl/refer self)))
