// Compiled by ClojureScript 1.10.339 {}
goog.provide('active.clojure.lens');
goog.require('cljs.core');
/**
 * Yank a value from the given data value, as defined by the given
 * lens.
 */
active.clojure.lens.yank = (function active$clojure$lens$yank(data,lens){
return lens.call(null,data);
});
/**
 * Shove a new value v into the given data value, as defined by the
 * given lens, and return the updated data structure.
 */
active.clojure.lens.shove = (function active$clojure$lens$shove(data,lens,v){
if((lens instanceof cljs.core.Keyword)){
return cljs.core.assoc.call(null,data,lens,v);
} else {
return lens.call(null,data,v);
}
});
active.clojure.lens.throw_invalid_number_of_arguments_error = (function active$clojure$lens$throw_invalid_number_of_arguments_error(n){
var error_msg = ["invalid number of arguments (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),") to lens"].join('');
throw (new java.lang.IllegalArgumentException(error_msg));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.lens.ExplicitLens = (function (yanker,shover,args,__meta,__extmap,__hash){
this.yanker = yanker;
this.shover = shover;
this.args = args;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.lens.ExplicitLens.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k7400,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__7405 = k7400;
var G__7405__$1 = (((G__7405 instanceof cljs.core.Keyword))?G__7405.fqn:null);
switch (G__7405__$1) {
case "yanker":
return self__.yanker;

break;
case "shover":
return self__.shover;

break;
case "args":
return self__.args;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k7400,else__4206__auto__);

}
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active.clojure.lens.ExplicitLens{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"yanker","yanker",1454070199),self__.yanker],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"shover","shover",-417196614),self__.shover],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"args","args",1315556576),self__.args],null))], null),self__.__extmap));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7399){
var self__ = this;
var G__7399__$1 = this;
return (new cljs.core.RecordIter((0),G__7399__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"yanker","yanker",1454070199),new cljs.core.Keyword(null,"shover","shover",-417196614),new cljs.core.Keyword(null,"args","args",1315556576)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active.clojure.lens.ExplicitLens(self__.yanker,self__.shover,self__.args,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (-1930886076 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this7401,other7402){
var self__ = this;
var this7401__$1 = this;
return ((!((other7402 == null))) && ((this7401__$1.constructor === other7402.constructor)) && (cljs.core._EQ_.call(null,this7401__$1.yanker,other7402.yanker)) && (cljs.core._EQ_.call(null,this7401__$1.shover,other7402.shover)) && (cljs.core._EQ_.call(null,this7401__$1.args,other7402.args)) && (cljs.core._EQ_.call(null,this7401__$1.__extmap,other7402.__extmap)));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"args","args",1315556576),null,new cljs.core.Keyword(null,"yanker","yanker",1454070199),null,new cljs.core.Keyword(null,"shover","shover",-417196614),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active.clojure.lens.ExplicitLens(self__.yanker,self__.shover,self__.args,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__7399){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__7406 = cljs.core.keyword_identical_QMARK_;
var expr__7407 = k__4211__auto__;
if(cljs.core.truth_(pred__7406.call(null,new cljs.core.Keyword(null,"yanker","yanker",1454070199),expr__7407))){
return (new active.clojure.lens.ExplicitLens(G__7399,self__.shover,self__.args,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__7406.call(null,new cljs.core.Keyword(null,"shover","shover",-417196614),expr__7407))){
return (new active.clojure.lens.ExplicitLens(self__.yanker,G__7399,self__.args,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__7406.call(null,new cljs.core.Keyword(null,"args","args",1315556576),expr__7407))){
return (new active.clojure.lens.ExplicitLens(self__.yanker,self__.shover,G__7399,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.lens.ExplicitLens(self__.yanker,self__.shover,self__.args,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__7399),null));
}
}
}
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"yanker","yanker",1454070199),self__.yanker,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"shover","shover",-417196614),self__.shover,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"args","args",1315556576),self__.args,null))], null),self__.__extmap));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__7399){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active.clojure.lens.ExplicitLens(self__.yanker,self__.shover,self__.args,G__7399,self__.__extmap,self__.__hash));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active.clojure.lens.ExplicitLens.prototype.call = (function() {
var G__7411 = null;
var G__7411__2 = (function (self__,data){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core.apply.call(null,self__.yanker,data,self__.args);
});
var G__7411__3 = (function (self__,data,v){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core.apply.call(null,self__.shover,data,v,self__.args);
});
G__7411 = function(self__,data,v){
switch(arguments.length){
case 2:
return G__7411__2.call(this,self__,data);
case 3:
return G__7411__3.call(this,self__,data,v);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__7411.cljs$core$IFn$_invoke$arity$2 = G__7411__2;
G__7411.cljs$core$IFn$_invoke$arity$3 = G__7411__3;
return G__7411;
})()
;

active.clojure.lens.ExplicitLens.prototype.apply = (function (self__,args7404){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args7404)));
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IFn$_invoke$arity$1 = (function (data){
var self__ = this;
var this$ = this;
return cljs.core.apply.call(null,self__.yanker,data,self__.args);
});

active.clojure.lens.ExplicitLens.prototype.cljs$core$IFn$_invoke$arity$2 = (function (data,v){
var self__ = this;
var this$ = this;
return cljs.core.apply.call(null,self__.shover,data,v,self__.args);
});

active.clojure.lens.ExplicitLens.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"yanker","yanker",-1200365570,null),new cljs.core.Symbol(null,"shover","shover",1223334913,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null);
});

active.clojure.lens.ExplicitLens.cljs$lang$type = true;

active.clojure.lens.ExplicitLens.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active.clojure.lens/ExplicitLens",null,(1),null));
});

active.clojure.lens.ExplicitLens.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active.clojure.lens/ExplicitLens");
});

/**
 * Positional factory function for active.clojure.lens/ExplicitLens.
 */
active.clojure.lens.__GT_ExplicitLens = (function active$clojure$lens$__GT_ExplicitLens(yanker,shover,args){
return (new active.clojure.lens.ExplicitLens(yanker,shover,args,null,null,null));
});

/**
 * Factory function for active.clojure.lens/ExplicitLens, taking a map of keywords to field values.
 */
active.clojure.lens.map__GT_ExplicitLens = (function active$clojure$lens$map__GT_ExplicitLens(G__7403){
var extmap__4236__auto__ = (function (){var G__7409 = cljs.core.dissoc.call(null,G__7403,new cljs.core.Keyword(null,"yanker","yanker",1454070199),new cljs.core.Keyword(null,"shover","shover",-417196614),new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.record_QMARK_.call(null,G__7403)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__7409);
} else {
return G__7409;
}
})();
return (new active.clojure.lens.ExplicitLens(new cljs.core.Keyword(null,"yanker","yanker",1454070199).cljs$core$IFn$_invoke$arity$1(G__7403),new cljs.core.Keyword(null,"shover","shover",-417196614).cljs$core$IFn$_invoke$arity$1(G__7403),new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(G__7403),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active.clojure.lens.ExplicitLensWithoutArgs = (function (yanker,shover,__meta,__extmap,__hash){
this.yanker = yanker;
this.shover = shover;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4203__auto__,k__4204__auto__){
var self__ = this;
var this__4203__auto____$1 = this;
return this__4203__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4204__auto__,null);
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4205__auto__,k7413,else__4206__auto__){
var self__ = this;
var this__4205__auto____$1 = this;
var G__7418 = k7413;
var G__7418__$1 = (((G__7418 instanceof cljs.core.Keyword))?G__7418.fqn:null);
switch (G__7418__$1) {
case "yanker":
return self__.yanker;

break;
case "shover":
return self__.shover;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k7413,else__4206__auto__);

}
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4217__auto__,writer__4218__auto__,opts__4219__auto__){
var self__ = this;
var this__4217__auto____$1 = this;
var pr_pair__4220__auto__ = ((function (this__4217__auto____$1){
return (function (keyval__4221__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,cljs.core.pr_writer,""," ","",opts__4219__auto__,keyval__4221__auto__);
});})(this__4217__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4218__auto__,pr_pair__4220__auto__,"#active.clojure.lens.ExplicitLensWithoutArgs{",", ","}",opts__4219__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"yanker","yanker",1454070199),self__.yanker],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"shover","shover",-417196614),self__.shover],null))], null),self__.__extmap));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7412){
var self__ = this;
var G__7412__$1 = this;
return (new cljs.core.RecordIter((0),G__7412__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"yanker","yanker",1454070199),new cljs.core.Keyword(null,"shover","shover",-417196614)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4201__auto__){
var self__ = this;
var this__4201__auto____$1 = this;
return self__.__meta;
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4198__auto__){
var self__ = this;
var this__4198__auto____$1 = this;
return (new active.clojure.lens.ExplicitLensWithoutArgs(self__.yanker,self__.shover,self__.__meta,self__.__extmap,self__.__hash));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4207__auto__){
var self__ = this;
var this__4207__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4199__auto__){
var self__ = this;
var this__4199__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__4199__auto____$1){
return (function (coll__4200__auto__){
return (757905071 ^ cljs.core.hash_unordered_coll.call(null,coll__4200__auto__));
});})(h__4061__auto__,this__4199__auto____$1))
.call(null,this__4199__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this7414,other7415){
var self__ = this;
var this7414__$1 = this;
return ((!((other7415 == null))) && ((this7414__$1.constructor === other7415.constructor)) && (cljs.core._EQ_.call(null,this7414__$1.yanker,other7415.yanker)) && (cljs.core._EQ_.call(null,this7414__$1.shover,other7415.shover)) && (cljs.core._EQ_.call(null,this7414__$1.__extmap,other7415.__extmap)));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4212__auto__,k__4213__auto__){
var self__ = this;
var this__4212__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"yanker","yanker",1454070199),null,new cljs.core.Keyword(null,"shover","shover",-417196614),null], null), null),k__4213__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4212__auto____$1),self__.__meta),k__4213__auto__);
} else {
return (new active.clojure.lens.ExplicitLensWithoutArgs(self__.yanker,self__.shover,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4213__auto__)),null));
}
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4210__auto__,k__4211__auto__,G__7412){
var self__ = this;
var this__4210__auto____$1 = this;
var pred__7419 = cljs.core.keyword_identical_QMARK_;
var expr__7420 = k__4211__auto__;
if(cljs.core.truth_(pred__7419.call(null,new cljs.core.Keyword(null,"yanker","yanker",1454070199),expr__7420))){
return (new active.clojure.lens.ExplicitLensWithoutArgs(G__7412,self__.shover,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__7419.call(null,new cljs.core.Keyword(null,"shover","shover",-417196614),expr__7420))){
return (new active.clojure.lens.ExplicitLensWithoutArgs(self__.yanker,G__7412,self__.__meta,self__.__extmap,null));
} else {
return (new active.clojure.lens.ExplicitLensWithoutArgs(self__.yanker,self__.shover,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4211__auto__,G__7412),null));
}
}
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4215__auto__){
var self__ = this;
var this__4215__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"yanker","yanker",1454070199),self__.yanker,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"shover","shover",-417196614),self__.shover,null))], null),self__.__extmap));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4202__auto__,G__7412){
var self__ = this;
var this__4202__auto____$1 = this;
return (new active.clojure.lens.ExplicitLensWithoutArgs(self__.yanker,self__.shover,G__7412,self__.__extmap,self__.__hash));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4208__auto__,entry__4209__auto__){
var self__ = this;
var this__4208__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4209__auto__)){
return this__4208__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4209__auto__,(0)),cljs.core._nth.call(null,entry__4209__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4208__auto____$1,entry__4209__auto__);
}
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.call = (function() {
var G__7424 = null;
var G__7424__2 = (function (self__,data){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return self__.yanker.call(null,data);
});
var G__7424__3 = (function (self__,data,v){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return self__.shover.call(null,data,v);
});
G__7424 = function(self__,data,v){
switch(arguments.length){
case 2:
return G__7424__2.call(this,self__,data);
case 3:
return G__7424__3.call(this,self__,data,v);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__7424.cljs$core$IFn$_invoke$arity$2 = G__7424__2;
G__7424.cljs$core$IFn$_invoke$arity$3 = G__7424__3;
return G__7424;
})()
;

active.clojure.lens.ExplicitLensWithoutArgs.prototype.apply = (function (self__,args7417){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args7417)));
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IFn$_invoke$arity$1 = (function (data){
var self__ = this;
var this$ = this;
return self__.yanker.call(null,data);
});

active.clojure.lens.ExplicitLensWithoutArgs.prototype.cljs$core$IFn$_invoke$arity$2 = (function (data,v){
var self__ = this;
var this$ = this;
return self__.shover.call(null,data,v);
});

active.clojure.lens.ExplicitLensWithoutArgs.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"yanker","yanker",-1200365570,null),new cljs.core.Symbol(null,"shover","shover",1223334913,null)], null);
});

active.clojure.lens.ExplicitLensWithoutArgs.cljs$lang$type = true;

active.clojure.lens.ExplicitLensWithoutArgs.cljs$lang$ctorPrSeq = (function (this__4240__auto__){
return (new cljs.core.List(null,"active.clojure.lens/ExplicitLensWithoutArgs",null,(1),null));
});

active.clojure.lens.ExplicitLensWithoutArgs.cljs$lang$ctorPrWriter = (function (this__4240__auto__,writer__4241__auto__){
return cljs.core._write.call(null,writer__4241__auto__,"active.clojure.lens/ExplicitLensWithoutArgs");
});

/**
 * Positional factory function for active.clojure.lens/ExplicitLensWithoutArgs.
 */
active.clojure.lens.__GT_ExplicitLensWithoutArgs = (function active$clojure$lens$__GT_ExplicitLensWithoutArgs(yanker,shover){
return (new active.clojure.lens.ExplicitLensWithoutArgs(yanker,shover,null,null,null));
});

/**
 * Factory function for active.clojure.lens/ExplicitLensWithoutArgs, taking a map of keywords to field values.
 */
active.clojure.lens.map__GT_ExplicitLensWithoutArgs = (function active$clojure$lens$map__GT_ExplicitLensWithoutArgs(G__7416){
var extmap__4236__auto__ = (function (){var G__7422 = cljs.core.dissoc.call(null,G__7416,new cljs.core.Keyword(null,"yanker","yanker",1454070199),new cljs.core.Keyword(null,"shover","shover",-417196614));
if(cljs.core.record_QMARK_.call(null,G__7416)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__7422);
} else {
return G__7422;
}
})();
return (new active.clojure.lens.ExplicitLensWithoutArgs(new cljs.core.Keyword(null,"yanker","yanker",1454070199).cljs$core$IFn$_invoke$arity$1(G__7416),new cljs.core.Keyword(null,"shover","shover",-417196614).cljs$core$IFn$_invoke$arity$1(G__7416),null,cljs.core.not_empty.call(null,extmap__4236__auto__),null));
});

/**
 * Returns a new lens defined by the given yanker function, which
 *   takes a data structure and must return the focused value, and the
 *   given shover function which takes a data structure and the new value
 *   in the focus. Any additional arguments are passed unchanged to the yank
 *   and shove functions.
 */
active.clojure.lens.lens = (function active$clojure$lens$lens(var_args){
var G__7429 = arguments.length;
switch (G__7429) {
case 2:
return active.clojure.lens.lens.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4546__auto__ = [];
var len__4531__auto___7431 = arguments.length;
var i__4532__auto___7432 = (0);
while(true){
if((i__4532__auto___7432 < len__4531__auto___7431)){
args_arr__4546__auto__.push((arguments[i__4532__auto___7432]));

var G__7433 = (i__4532__auto___7432 + (1));
i__4532__auto___7432 = G__7433;
continue;
} else {
}
break;
}

var argseq__4547__auto__ = (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((2)),(0),null));
return active.clojure.lens.lens.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4547__auto__);

}
});

active.clojure.lens.lens.cljs$core$IFn$_invoke$arity$2 = (function (yanker,shover){
return (new active.clojure.lens.ExplicitLensWithoutArgs(yanker,shover,null,null,null));
});

active.clojure.lens.lens.cljs$core$IFn$_invoke$arity$variadic = (function (yanker,shover,args){
return (new active.clojure.lens.ExplicitLens(yanker,shover,args,null,null,null));
});

/** @this {Function} */
active.clojure.lens.lens.cljs$lang$applyTo = (function (seq7426){
var G__7427 = cljs.core.first.call(null,seq7426);
var seq7426__$1 = cljs.core.next.call(null,seq7426);
var G__7428 = cljs.core.first.call(null,seq7426__$1);
var seq7426__$2 = cljs.core.next.call(null,seq7426__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7427,G__7428,seq7426__$2);
});

active.clojure.lens.lens.cljs$lang$maxFixedArity = (2);

active.clojure.lens.xmap_yank = (function active$clojure$lens$xmap_yank(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7438 = arguments.length;
var i__4532__auto___7439 = (0);
while(true){
if((i__4532__auto___7439 < len__4531__auto___7438)){
args__4534__auto__.push((arguments[i__4532__auto___7439]));

var G__7440 = (i__4532__auto___7439 + (1));
i__4532__auto___7439 = G__7440;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return active.clojure.lens.xmap_yank.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

active.clojure.lens.xmap_yank.cljs$core$IFn$_invoke$arity$variadic = (function (data,f,g,args){
return cljs.core.apply.call(null,f,data,args);
});

active.clojure.lens.xmap_yank.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
active.clojure.lens.xmap_yank.cljs$lang$applyTo = (function (seq7434){
var G__7435 = cljs.core.first.call(null,seq7434);
var seq7434__$1 = cljs.core.next.call(null,seq7434);
var G__7436 = cljs.core.first.call(null,seq7434__$1);
var seq7434__$2 = cljs.core.next.call(null,seq7434__$1);
var G__7437 = cljs.core.first.call(null,seq7434__$2);
var seq7434__$3 = cljs.core.next.call(null,seq7434__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7435,G__7436,G__7437,seq7434__$3);
});

active.clojure.lens.xmap_shove = (function active$clojure$lens$xmap_shove(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7446 = arguments.length;
var i__4532__auto___7447 = (0);
while(true){
if((i__4532__auto___7447 < len__4531__auto___7446)){
args__4534__auto__.push((arguments[i__4532__auto___7447]));

var G__7448 = (i__4532__auto___7447 + (1));
i__4532__auto___7447 = G__7448;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return active.clojure.lens.xmap_shove.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

active.clojure.lens.xmap_shove.cljs$core$IFn$_invoke$arity$variadic = (function (data,v,f,g,args){
return cljs.core.apply.call(null,g,v,args);
});

active.clojure.lens.xmap_shove.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
active.clojure.lens.xmap_shove.cljs$lang$applyTo = (function (seq7441){
var G__7442 = cljs.core.first.call(null,seq7441);
var seq7441__$1 = cljs.core.next.call(null,seq7441);
var G__7443 = cljs.core.first.call(null,seq7441__$1);
var seq7441__$2 = cljs.core.next.call(null,seq7441__$1);
var G__7444 = cljs.core.first.call(null,seq7441__$2);
var seq7441__$3 = cljs.core.next.call(null,seq7441__$2);
var G__7445 = cljs.core.first.call(null,seq7441__$3);
var seq7441__$4 = cljs.core.next.call(null,seq7441__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7442,G__7443,G__7444,G__7445,seq7441__$4);
});

/**
 * Updates data using a lens.  The new value will be determined by
 *   applying `f` to the old value and any other supplied arguments.
 */
active.clojure.lens.overhaul = (function active$clojure$lens$overhaul(var_args){
var G__7454 = arguments.length;
switch (G__7454) {
case 3:
return active.clojure.lens.overhaul.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4546__auto__ = [];
var len__4531__auto___7456 = arguments.length;
var i__4532__auto___7457 = (0);
while(true){
if((i__4532__auto___7457 < len__4531__auto___7456)){
args_arr__4546__auto__.push((arguments[i__4532__auto___7457]));

var G__7458 = (i__4532__auto___7457 + (1));
i__4532__auto___7457 = G__7458;
continue;
} else {
}
break;
}

var argseq__4547__auto__ = (new cljs.core.IndexedSeq(args_arr__4546__auto__.slice((3)),(0),null));
return active.clojure.lens.overhaul.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4547__auto__);

}
});

active.clojure.lens.overhaul.cljs$core$IFn$_invoke$arity$3 = (function (data,lens,f){
return active.clojure.lens.shove.call(null,data,lens,f.call(null,active.clojure.lens.yank.call(null,data,lens)));
});

active.clojure.lens.overhaul.cljs$core$IFn$_invoke$arity$variadic = (function (data,lens,f,args){
return active.clojure.lens.shove.call(null,data,lens,cljs.core.apply.call(null,f,active.clojure.lens.yank.call(null,data,lens),args));
});

/** @this {Function} */
active.clojure.lens.overhaul.cljs$lang$applyTo = (function (seq7450){
var G__7451 = cljs.core.first.call(null,seq7450);
var seq7450__$1 = cljs.core.next.call(null,seq7450);
var G__7452 = cljs.core.first.call(null,seq7450__$1);
var seq7450__$2 = cljs.core.next.call(null,seq7450__$1);
var G__7453 = cljs.core.first.call(null,seq7450__$2);
var seq7450__$3 = cljs.core.next.call(null,seq7450__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7451,G__7452,G__7453,seq7450__$3);
});

active.clojure.lens.overhaul.cljs$lang$maxFixedArity = (3);

/**
 * Returns a "view lens", that transforms a whole data structure
 * to something else (f) and back (g).
 */
active.clojure.lens.xmap = (function active$clojure$lens$xmap(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7462 = arguments.length;
var i__4532__auto___7463 = (0);
while(true){
if((i__4532__auto___7463 < len__4531__auto___7462)){
args__4534__auto__.push((arguments[i__4532__auto___7463]));

var G__7464 = (i__4532__auto___7463 + (1));
i__4532__auto___7463 = G__7464;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return active.clojure.lens.xmap.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

active.clojure.lens.xmap.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,args){
return cljs.core.apply.call(null,active.clojure.lens.lens,active.clojure.lens.xmap_yank,active.clojure.lens.xmap_shove,f,g,args);
});

active.clojure.lens.xmap.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
active.clojure.lens.xmap.cljs$lang$applyTo = (function (seq7459){
var G__7460 = cljs.core.first.call(null,seq7459);
var seq7459__$1 = cljs.core.next.call(null,seq7459);
var G__7461 = cljs.core.first.call(null,seq7459__$1);
var seq7459__$2 = cljs.core.next.call(null,seq7459__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7460,G__7461,seq7459__$2);
});

/**
 * Identity lens, that just show a data structure as it is.
 *        It's also the neutral element of lens concatenation
 *        `reacl.lens/>>`.
 */
active.clojure.lens.id = active.clojure.lens.xmap.call(null,cljs.core.identity,cljs.core.identity);
active.clojure.lens.keyword_shove = (function active$clojure$lens$keyword_shove(data,val,key){
return cljs.core.assoc.call(null,data,key,val);
});
active.clojure.lens.keyword_lens = (function active$clojure$lens$keyword_lens(kw){
return active.clojure.lens.lens.call(null,cljs.core.get,active.clojure.lens.keyword_shove,kw);
});
active.clojure.lens.lift_lens = (function active$clojure$lens$lift_lens(my_lens){
if((my_lens instanceof cljs.core.Keyword)){
return active.clojure.lens.keyword_lens.call(null,my_lens);
} else {
return my_lens;
}
});
active.clojure.lens.comb_yank = (function active$clojure$lens$comb_yank(data,lenses){
return cljs.core.reduce.call(null,(function (data__$1,my_lens){
return my_lens.call(null,data__$1);
}),data,lenses);
});
active.clojure.lens.comb_shove = (function active$clojure$lens$comb_shove(data,val,lenses){
var lens_1 = cljs.core.first.call(null,lenses);
var remaining = cljs.core.rest.call(null,lenses);
if(cljs.core.empty_QMARK_.call(null,remaining)){
return lens_1.call(null,data,val);
} else {
return lens_1.call(null,data,active.clojure.lens.comb_shove.call(null,lens_1.call(null,data),val,remaining));
}
});
/**
 * Returns a concatenation of lenses, so that the combination shows the
 * value of the last one, in a data structure that the first one is put
 * over.
 */
active.clojure.lens._GT__GT_ = (function active$clojure$lens$_GT__GT_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7466 = arguments.length;
var i__4532__auto___7467 = (0);
while(true){
if((i__4532__auto___7467 < len__4531__auto___7466)){
args__4534__auto__.push((arguments[i__4532__auto___7467]));

var G__7468 = (i__4532__auto___7467 + (1));
i__4532__auto___7467 = G__7468;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return active.clojure.lens._GT__GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

active.clojure.lens._GT__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (lenses){
var non_trivial_lenses = cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([active.clojure.lens.id]),lenses);
if(cljs.core.empty_QMARK_.call(null,cljs.core.rest.call(null,non_trivial_lenses))){
var or__3949__auto__ = cljs.core.first.call(null,non_trivial_lenses);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return active.clojure.lens.id;
}
} else {
return active.clojure.lens.lens.call(null,active.clojure.lens.comb_yank,active.clojure.lens.comb_shove,cljs.core.mapv.call(null,active.clojure.lens.lift_lens,non_trivial_lenses));
}
});

active.clojure.lens._GT__GT_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.lens._GT__GT_.cljs$lang$applyTo = (function (seq7465){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7465));
});

active.clojure.lens.default_yank = (function active$clojure$lens$default_yank(data,dflt){
if((data == null)){
return dflt;
} else {
return data;
}
});
active.clojure.lens.default_shove = (function active$clojure$lens$default_shove(v,dflt){
if(cljs.core._EQ_.call(null,dflt,v)){
return null;
} else {
return v;
}
});
/**
 * Returns a lens that shows nil as the given default value, but does not change any other value.
 */
active.clojure.lens.default$ = (function active$clojure$lens$default(dflt){
return active.clojure.lens.xmap.call(null,active.clojure.lens.default_yank,active.clojure.lens.default_shove,dflt);
});
active.clojure.lens.consx = (function active$clojure$lens$consx(v,coll){
if((((v == null)) && (cljs.core.empty_QMARK_.call(null,coll)))){
return coll;
} else {
return cljs.core.cons.call(null,v,coll);
}
});
/**
 * A lens focusing on the first element in a collection. It
 *   yanks nil if the collection is empty, and will not insert nil into an empty collection.
 */
active.clojure.lens.head = active.clojure.lens.lens.call(null,cljs.core.first,(function (p1__7470_SHARP_,p2__7469_SHARP_){
return active.clojure.lens.consx.call(null,p2__7469_SHARP_,cljs.core.rest.call(null,p1__7470_SHARP_));
}));
/**
 * A lens focusing on the first element in a non-empty
 *   collection. Behaviour on an empty collection is undefined.
 */
active.clojure.lens.nel_head = active.clojure.lens.lens.call(null,cljs.core.first,(function (p1__7472_SHARP_,p2__7471_SHARP_){
return cljs.core.cons.call(null,p2__7471_SHARP_,cljs.core.rest.call(null,p1__7472_SHARP_));
}));
/**
 * A lens focusing on the all but the first element in a collection.
 *   Note that nil will be prepended when shoving into an empty collection.
 */
active.clojure.lens.tail = active.clojure.lens.lens.call(null,cljs.core.rest,(function (p1__7473_SHARP_,p2__7474_SHARP_){
return active.clojure.lens.consx.call(null,cljs.core.first.call(null,p1__7473_SHARP_),p2__7474_SHARP_);
}));
/**
 * A lens focusing on the all but the first element in a non-empty collection.
 *   Behaviour on an empty collection is undefined.
 */
active.clojure.lens.nel_tail = active.clojure.lens.lens.call(null,cljs.core.rest,(function (p1__7475_SHARP_,p2__7476_SHARP_){
return cljs.core.cons.call(null,cljs.core.first.call(null,p1__7475_SHARP_),p2__7476_SHARP_);
}));
/**
 * A lens over the nth element in a collection. Note that when shoving a
 *   new value `nil`s may be added before the given position, if the collection is smaller.
 */
active.clojure.lens.pos = (function active$clojure$lens$pos(n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

if((n >= (0))){
} else {
throw (new Error("Assert failed: (>= n 0)"));
}

return cljs.core.apply.call(null,active.clojure.lens._GT__GT_,cljs.core.conj.call(null,cljs.core.vec.call(null,cljs.core.repeat.call(null,n,active.clojure.lens.tail)),active.clojure.lens.head));
});
/**
 * A lens that views a sequence as a set.
 */
active.clojure.lens.as_set = active.clojure.lens.lens.call(null,cljs.core.set,(function (p1__7477_SHARP_,p2__7478_SHARP_){
if(cljs.core._EQ_.call(null,cljs.core.set.call(null,p1__7477_SHARP_),p2__7478_SHARP_)){
return p1__7477_SHARP_;
} else {
return cljs.core.seq.call(null,p2__7478_SHARP_);
}
}));
active.clojure.lens.contains_shove = (function active$clojure$lens$contains_shove(data,mem_QMARK_,v){
if(cljs.core.truth_(mem_QMARK_)){
return cljs.core.conj.call(null,data,v);
} else {
return cljs.core.disj.call(null,data,v);
}
});
/**
 * Returns a lens showing the membership of the given value in a set.
 */
active.clojure.lens.contains = (function active$clojure$lens$contains(v){
return active.clojure.lens.lens.call(null,cljs.core.contains_QMARK_,active.clojure.lens.contains_shove,v);
});
/**
 * A lens that views a sequence of pairs as a map.
 */
active.clojure.lens.as_map = active.clojure.lens.xmap.call(null,(function (p1__7479_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,p1__7479_SHARP_);
}),cljs.core.seq);
active.clojure.lens.member_shove = (function active$clojure$lens$member_shove(data,v,key,not_found){
if(cljs.core._EQ_.call(null,v,not_found)){
return cljs.core.dissoc.call(null,data,key);
} else {
return cljs.core.assoc.call(null,data,key,v);
}
});
/**
 * Returns a lens showing the value mapped to the given key in a map,
 *   not-found or nil if key is not present. Note that when not-found (or
 *   nil) is shoved into the map, the association is removed.
 */
active.clojure.lens.member = (function active$clojure$lens$member(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7486 = arguments.length;
var i__4532__auto___7487 = (0);
while(true){
if((i__4532__auto___7487 < len__4531__auto___7486)){
args__4534__auto__.push((arguments[i__4532__auto___7487]));

var G__7488 = (i__4532__auto___7487 + (1));
i__4532__auto___7487 = G__7488;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return active.clojure.lens.member.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

active.clojure.lens.member.cljs$core$IFn$_invoke$arity$variadic = (function (key,p__7482){
var vec__7483 = p__7482;
var not_found = cljs.core.nth.call(null,vec__7483,(0),null);
return active.clojure.lens.lens.call(null,cljs.core.get,active.clojure.lens.member_shove,key,not_found);
});

active.clojure.lens.member.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
active.clojure.lens.member.cljs$lang$applyTo = (function (seq7480){
var G__7481 = cljs.core.first.call(null,seq7480);
var seq7480__$1 = cljs.core.next.call(null,seq7480);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7481,seq7480__$1);
});

/**
 * A trivial lens that just shows nil over anything, and does never change anything.
 */
active.clojure.lens.void$ = active.clojure.lens.lens.call(null,cljs.core.constantly.call(null,null),(function (data,_){
return data;
}));
active.clojure.lens.is_shove = (function active$clojure$lens$is_shove(data,is_QMARK_,cmp){
if(cljs.core.truth_(is_QMARK_)){
return cmp;
} else {
if(cljs.core._EQ_.call(null,data,cmp)){
return null;
} else {
return data;
}
}
});
/**
 * Returns a lens showing if a data structure equals the non-nil value v.
 */
active.clojure.lens.is = (function active$clojure$lens$is(v){
if(!((v == null))){
} else {
throw (new Error("Assert failed: (not (nil? v))"));
}

return active.clojure.lens.lens.call(null,cljs.core._EQ_,active.clojure.lens.is_shove,v);
});
active.clojure.lens.mult_yank = (function active$clojure$lens$mult_yank(data,lenses){
return cljs.core.map.call(null,active.clojure.lens.yank,data,lenses);
});
active.clojure.lens.mult_shove = (function active$clojure$lens$mult_shove(data,v,lenses){
return cljs.core.map.call(null,active.clojure.lens.shove,data,lenses,v);
});
/**
 * Return the product of several lenses, which means that each lens is
 *   held over an element of a collection in the order they appear in the
 *   argument list.
 */
active.clojure.lens._STAR__STAR_ = (function active$clojure$lens$_STAR__STAR_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7490 = arguments.length;
var i__4532__auto___7491 = (0);
while(true){
if((i__4532__auto___7491 < len__4531__auto___7490)){
args__4534__auto__.push((arguments[i__4532__auto___7491]));

var G__7492 = (i__4532__auto___7491 + (1));
i__4532__auto___7491 = G__7492;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return active.clojure.lens._STAR__STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

active.clojure.lens._STAR__STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (lenses){
return active.clojure.lens.lens.call(null,active.clojure.lens.mult_yank,active.clojure.lens.mult_shove,lenses);
});

active.clojure.lens._STAR__STAR_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.lens._STAR__STAR_.cljs$lang$applyTo = (function (seq7489){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7489));
});

active.clojure.lens.plus_yank = (function active$clojure$lens$plus_yank(data,lenses){
return cljs.core.map.call(null,active.clojure.lens.yank,cljs.core.repeat.call(null,data),lenses);
});
active.clojure.lens.plus_shove = (function active$clojure$lens$plus_shove(data,v,lenses){
return cljs.core.reduce.call(null,(function (data__$1,p__7493){
var vec__7494 = p__7493;
var l = cljs.core.nth.call(null,vec__7494,(0),null);
var v__$1 = cljs.core.nth.call(null,vec__7494,(1),null);
return active.clojure.lens.shove.call(null,data__$1,l,v__$1);
}),data,cljs.core.map.call(null,cljs.core.vector,lenses,v));
});
/**
 * Returns a lens over some data structure that shows a sequence of
 *   elements that each of the given lenses show on that. Note that the
 *   behaviour is undefined if those lenses do not show distrinct parts
 *   of the data structure.
 */
active.clojure.lens._PLUS__PLUS_ = (function active$clojure$lens$_PLUS__PLUS_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___7498 = arguments.length;
var i__4532__auto___7499 = (0);
while(true){
if((i__4532__auto___7499 < len__4531__auto___7498)){
args__4534__auto__.push((arguments[i__4532__auto___7499]));

var G__7500 = (i__4532__auto___7499 + (1));
i__4532__auto___7499 = G__7500;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return active.clojure.lens._PLUS__PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

active.clojure.lens._PLUS__PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (lenses){
return active.clojure.lens.lens.call(null,active.clojure.lens.plus_yank,active.clojure.lens.plus_shove,lenses);
});

active.clojure.lens._PLUS__PLUS_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
active.clojure.lens._PLUS__PLUS_.cljs$lang$applyTo = (function (seq7497){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7497));
});

active.clojure.lens.at_index_shove = (function active$clojure$lens$at_index_shove(coll,v,n){
var vec__7501 = cljs.core.split_at.call(null,n,coll);
var front = cljs.core.nth.call(null,vec__7501,(0),null);
var back = cljs.core.nth.call(null,vec__7501,(1),null);
return cljs.core.concat.call(null,front,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),cljs.core.rest.call(null,back));
});
/**
 * Returns a lens that focuses on the value at position n in a sequence.
 *   The sequence must have >= n elements.
 */
active.clojure.lens.at_index = (function active$clojure$lens$at_index(n){
return active.clojure.lens.lens.call(null,cljs.core.nth,active.clojure.lens.at_index_shove,n);
});

//# sourceMappingURL=lens.js.map
