// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.interpolation.simple_splines');
goog.require('cljs.core');
goog.require('active_viz.interpolation.util');
active_viz.interpolation.simple_splines.line = (function active_viz$interpolation$simple_splines$line(point1,point2){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"length","length",588987862),active_viz.interpolation.util.distance.call(null,point1,point2),new cljs.core.Keyword(null,"angle","angle",1622094254),active_viz.interpolation.util.angle.call(null,point1,point2)], null);
});
active_viz.interpolation.simple_splines.control_point = (function active_viz$interpolation$simple_splines$control_point(previous,current,next,reverse_QMARK_,smoothness){
var p = (function (){var or__3949__auto__ = previous;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return current;
}
})();
var n = (function (){var or__3949__auto__ = next;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return current;
}
})();
var l = active_viz.interpolation.simple_splines.line.call(null,p,n);
var line_angle = (new cljs.core.Keyword(null,"angle","angle",1622094254).cljs$core$IFn$_invoke$arity$1(l) + (cljs.core.truth_(reverse_QMARK_)?Math.PI:(0)));
var line_length = (smoothness * new cljs.core.Keyword(null,"length","length",588987862).cljs$core$IFn$_invoke$arity$1(l));
var vec__12019 = current;
var cx = cljs.core.nth.call(null,vec__12019,(0),null);
var cy = cljs.core.nth.call(null,vec__12019,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cx + (line_length * Math.cos(line_angle))),(cy + (line_length * Math.sin(line_angle)))], null);
});
active_viz.interpolation.simple_splines.points__GT_control_points = (function active_viz$interpolation$simple_splines$points__GT_control_points(p_2,p_1,p,p_PLUS_1,p_PLUS_2,smoothness){
var cp1 = active_viz.interpolation.simple_splines.control_point.call(null,p_2,p_1,p,false,smoothness);
var cp2 = active_viz.interpolation.simple_splines.control_point.call(null,p_1,p,p_PLUS_1,true,smoothness);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cp1,cp2], null);
});
/**
 * Does a simple splines interpolation via control points by
 *   using the angle and distance between successive points. 
 * 
 *   Takes a list of points (`[x y]`) and returns a list of spline
 *   control-points tuples for each point in `points`. 
 * 
 * 
 *   The factor smoothness defines the smoothing between points, where
 *   a high value results in high smoothing. We recommend values between 0 and 1,
 *   however, these highly depend on the data in `points`. 
 */
active_viz.interpolation.simple_splines.interpolate = (function active_viz$interpolation$simple_splines$interpolate(points,smoothness){
var l = cljs.core.count.call(null,points);
var points__$1 = cljs.core.vec.call(null,points);
return cljs.core.reverse.call(null,(function (){var acc = cljs.core.PersistentVector.EMPTY;
var i = (0);
while(true){
if((i >= l)){
return acc;
} else {
var p_2 = cljs.core.get.call(null,points__$1,(i - (2)));
var p_1 = cljs.core.get.call(null,points__$1,(i - (1)));
var p = cljs.core.get.call(null,points__$1,i);
var p_PLUS_1 = cljs.core.get.call(null,points__$1,(i + (1)));
var p_PLUS_2 = cljs.core.get.call(null,points__$1,(i + (2)));
var G__12022 = cljs.core.cons.call(null,active_viz.interpolation.simple_splines.points__GT_control_points.call(null,p_2,p_1,p,p_PLUS_1,p_PLUS_2,smoothness),acc);
var G__12023 = (i + (1));
acc = G__12022;
i = G__12023;
continue;
}
break;
}
})());
});

//# sourceMappingURL=simple_splines.js.map
