// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.interpolation.util');
goog.require('cljs.core');
active_viz.interpolation.util.eps = Number.EPSILON;
/**
 * Computes the slope described by two points
 */
active_viz.interpolation.util.slope = (function active_viz$interpolation$util$slope(p__11989,p__11990){
var vec__11991 = p__11989;
var x1 = cljs.core.nth.call(null,vec__11991,(0),null);
var y1 = cljs.core.nth.call(null,vec__11991,(1),null);
var vec__11994 = p__11990;
var x2 = cljs.core.nth.call(null,vec__11994,(0),null);
var y2 = cljs.core.nth.call(null,vec__11994,(1),null);
return ((y2 - y1) / (x2 - x1));
});
/**
 * Computes the 3 point differences for each point
 *   https://en.wikipedia.org/wiki/Cubic_Hermite_spline#Finite_difference 
 */
active_viz.interpolation.util.finite_differences = (function active_viz$interpolation$util$finite_differences(points){
var p0 = cljs.core.first.call(null,points);
var p1 = cljs.core.second.call(null,points);
var points_STAR_ = cljs.core.drop.call(null,(2),points);
var d = active_viz.interpolation.util.slope.call(null,p0,p1);
return cljs.core.reverse.call(null,cljs.core.first.call(null,cljs.core.reduce.call(null,((function (p0,p1,points_STAR_,d){
return (function (p__11997,point){
var vec__11998 = p__11997;
var acc = cljs.core.nth.call(null,vec__11998,(0),null);
var prev_point = cljs.core.nth.call(null,vec__11998,(1),null);
var d__$1 = cljs.core.first.call(null,acc);
var d_STAR_ = ((d__$1 + active_viz.interpolation.util.slope.call(null,prev_point,point)) / (2));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cons.call(null,d_STAR_,acc),point], null);
});})(p0,p1,points_STAR_,d))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [d], null),p1], null),points)));
});
/**
 * If n is NaN it returns 0 else n
 */
active_viz.interpolation.util.number_or_zero = (function active_viz$interpolation$util$number_or_zero(n){
if(cljs.core.truth_(Number.isNaN(n))){
return (0);
} else {
return n;
}
});
active_viz.interpolation.util.distance = (function active_viz$interpolation$util$distance(p__12001,p__12002){
var vec__12003 = p__12001;
var x1 = cljs.core.nth.call(null,vec__12003,(0),null);
var y1 = cljs.core.nth.call(null,vec__12003,(1),null);
var vec__12006 = p__12002;
var x2 = cljs.core.nth.call(null,vec__12006,(0),null);
var y2 = cljs.core.nth.call(null,vec__12006,(1),null);
return Math.sqrt((Math.pow((x2 - x1),(2)) + Math.pow((y2 - y1),(2))));
});
active_viz.interpolation.util.angle = (function active_viz$interpolation$util$angle(p__12009,p__12010){
var vec__12011 = p__12009;
var x1 = cljs.core.nth.call(null,vec__12011,(0),null);
var y1 = cljs.core.nth.call(null,vec__12011,(1),null);
var vec__12014 = p__12010;
var x2 = cljs.core.nth.call(null,vec__12014,(0),null);
var y2 = cljs.core.nth.call(null,vec__12014,(1),null);
return Math.atan2((y2 - y1),(x2 - x1));
});

//# sourceMappingURL=util.js.map
