// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.scale.time_scale');
goog.require('cljs.core');
goog.require('cljs_time.coerce');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('active_viz.scale.linear_scale');
goog.require('active.clojure.cljs.record');
goog.require('active_viz.ticks');
goog.require('active_viz.scale.types');





/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.time_scale.Unit = (function (time_unit,time_constructor,approx_ms,nice_values,__meta,__extmap,__hash){
this.time_unit = time_unit;
this.time_constructor = time_constructor;
this.approx_ms = approx_ms;
this.nice_values = nice_values;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__9707__auto__,k__9708__auto__){
var self__ = this;
var this__9707__auto____$1 = this;
return this__9707__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__9708__auto__,null);
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__9709__auto__,k10537,else__9710__auto__){
var self__ = this;
var this__9709__auto____$1 = this;
var G__10541 = k10537;
var G__10541__$1 = (((G__10541 instanceof cljs.core.Keyword))?G__10541.fqn:null);
switch (G__10541__$1) {
case "time-unit":
return self__.time_unit;

break;
case "time-constructor":
return self__.time_constructor;

break;
case "approx-ms":
return self__.approx_ms;

break;
case "nice-values":
return self__.nice_values;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k10537,else__9710__auto__);

}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__9717__auto__,writer__9718__auto__,opts__9719__auto__){
var self__ = this;
var this__9717__auto____$1 = this;
var pr_pair__9720__auto__ = ((function (this__9717__auto____$1){
return (function (keyval__9721__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,cljs.core.pr_writer,""," ","",opts__9719__auto__,keyval__9721__auto__);
});})(this__9717__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,pr_pair__9720__auto__,"#active-viz.scale.time-scale.Unit{",", ","}",opts__9719__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values],null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10536){
var self__ = this;
var G__10536__$1 = this;
return (new cljs.core.RecordIter((0),G__10536__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__9705__auto__){
var self__ = this;
var this__9705__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__9702__auto__){
var self__ = this;
var this__9702__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__9711__auto__){
var self__ = this;
var this__9711__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__9703__auto__){
var self__ = this;
var this__9703__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__9703__auto____$1){
return (function (coll__9704__auto__){
return (1780693712 ^ cljs.core.hash_unordered_coll.call(null,coll__9704__auto__));
});})(h__4061__auto__,this__9703__auto____$1))
.call(null,this__9703__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10538,other10539){
var self__ = this;
var this10538__$1 = this;
return ((!((other10539 == null))) && ((this10538__$1.constructor === other10539.constructor)) && (cljs.core._EQ_.call(null,this10538__$1.time_unit,other10539.time_unit)) && (cljs.core._EQ_.call(null,this10538__$1.time_constructor,other10539.time_constructor)) && (cljs.core._EQ_.call(null,this10538__$1.approx_ms,other10539.approx_ms)) && (cljs.core._EQ_.call(null,this10538__$1.nice_values,other10539.nice_values)) && (cljs.core._EQ_.call(null,this10538__$1.__extmap,other10539.__extmap)));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__9700__auto__,k__9701__auto__){
var self__ = this;
var this__9700__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"nice-values","nice-values",9595080),null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),null], null), null),k__9701__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__9700__auto____$1),self__.__meta),k__9701__auto__);
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__9701__auto__)),null));
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__9698__auto__,k__9699__auto__,G__10536){
var self__ = this;
var this__9698__auto____$1 = this;
var pred__10542 = cljs.core.keyword_identical_QMARK_;
var expr__10543 = k__9699__auto__;
if(cljs.core.truth_(pred__10542.call(null,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),expr__10543))){
return (new active_viz.scale.time_scale.Unit(G__10536,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__10542.call(null,new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),expr__10543))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,G__10536,self__.approx_ms,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__10542.call(null,new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),expr__10543))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,G__10536,self__.nice_values,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__10542.call(null,new cljs.core.Keyword(null,"nice-values","nice-values",9595080),expr__10543))){
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,G__10536,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__9699__auto__,G__10536),null));
}
}
}
}
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__9715__auto__){
var self__ = this;
var this__9715__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-unit","time-unit",658316264),self__.time_unit,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),self__.time_constructor,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),self__.approx_ms,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"nice-values","nice-values",9595080),self__.nice_values,null))], null),self__.__extmap));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__9706__auto__,G__10536){
var self__ = this;
var this__9706__auto____$1 = this;
return (new active_viz.scale.time_scale.Unit(self__.time_unit,self__.time_constructor,self__.approx_ms,self__.nice_values,G__10536,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.Unit.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__9712__auto__,entry__9713__auto__){
var self__ = this;
var this__9712__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__9713__auto__)){
return this__9712__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__9713__auto__,(0)),cljs.core._nth.call(null,entry__9713__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__9712__auto____$1,entry__9713__auto__);
}
});

active_viz.scale.time_scale.Unit.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"time-unit","time-unit",-1996119505,null),new cljs.core.Symbol(null,"time-constructor","time-constructor",1975064803,null),new cljs.core.Symbol(null,"approx-ms","approx-ms",-929702522,null),new cljs.core.Symbol(null,"nice-values","nice-values",1650126607,null)], null);
});

active_viz.scale.time_scale.Unit.cljs$lang$type = true;

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrSeq = (function (this__9793__auto__){
return (new cljs.core.List(null,"active-viz.scale.time-scale/Unit",null,(1),null));
});

active_viz.scale.time_scale.Unit.cljs$lang$ctorPrWriter = (function (this__9793__auto__,writer__9794__auto__){
return cljs.core._write.call(null,writer__9794__auto__,"active-viz.scale.time-scale/Unit");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Positional factory function for active-viz.scale.time-scale/Unit.
 */
active_viz.scale.time_scale.__GT_Unit = (function active_viz$scale$time_scale$__GT_Unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});
}

/**
 * Factory function for active-viz.scale.time-scale/Unit, taking a map of keywords to field values.
 */
active_viz.scale.time_scale.map__GT_Unit = (function active_viz$scale$time_scale$map__GT_Unit(G__10540){
var extmap__9615__auto__ = (function (){var G__10545 = cljs.core.dissoc.call(null,G__10540,new cljs.core.Keyword(null,"time-unit","time-unit",658316264),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247),new cljs.core.Keyword(null,"nice-values","nice-values",9595080));
if(cljs.core.record_QMARK_.call(null,G__10540)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__10545);
} else {
return G__10545;
}
})();
return (new active_viz.scale.time_scale.Unit(new cljs.core.Keyword(null,"time-unit","time-unit",658316264).cljs$core$IFn$_invoke$arity$1(G__10540),new cljs.core.Keyword(null,"time-constructor","time-constructor",334533276).cljs$core$IFn$_invoke$arity$1(G__10540),new cljs.core.Keyword(null,"approx-ms","approx-ms",1724733247).cljs$core$IFn$_invoke$arity$1(G__10540),new cljs.core.Keyword(null,"nice-values","nice-values",9595080).cljs$core$IFn$_invoke$arity$1(G__10540),null,cljs.core.not_empty.call(null,extmap__9615__auto__),null));
});

/**
 * Is object a `Unit` record? See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_QMARK_ = (function active_viz$scale$time_scale$unit_QMARK_(x__9795__auto__){
return (x__9795__auto__ instanceof active_viz.scale.time_scale.Unit);
});

/**
 * Construct a `Unit` record.
 * 
 * `time-unit`: access via [[active-viz.scale.time-scale/unit-time-unit]]
 * `time-constructor`: access via [[active-viz.scale.time-scale/unit-time-constructor]]
 * `approx-ms`: access via [[active-viz.scale.time-scale/unit-approx-ms]]
 * `nice-values`: access via [[active-viz.scale.time-scale/unit-nice-values]]
 */
active_viz.scale.time_scale.make_unit = (function active_viz$scale$time_scale$make_unit(time_unit,time_constructor,approx_ms,nice_values){
return (new active_viz.scale.time_scale.Unit(time_unit,time_constructor,approx_ms,nice_values,null,null,null));
});





/**
 * Lens for the `time-unit` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_unit = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.time_scale.Unit)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (unit-time-unit)."));
}

return rec__9774__auto__.time_unit;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.time_scale.Unit(v__9776__auto__,active_viz.scale.time_scale.unit_time_constructor.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_approx_ms.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_nice_values.call(null,data__9775__auto__),null,null,null));
}));


/**
 * Lens for the `time-constructor` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_time_constructor = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.time_scale.Unit)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (unit-time-constructor)."));
}

return rec__9774__auto__.time_constructor;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.time_scale.Unit(active_viz.scale.time_scale.unit_time_unit.call(null,data__9775__auto__),v__9776__auto__,active_viz.scale.time_scale.unit_approx_ms.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_nice_values.call(null,data__9775__auto__),null,null,null));
}));


/**
 * Lens for the `approx-ms` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_approx_ms = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.time_scale.Unit)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (unit-approx-ms)."));
}

return rec__9774__auto__.approx_ms;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.time_scale.Unit(active_viz.scale.time_scale.unit_time_unit.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_time_constructor.call(null,data__9775__auto__),v__9776__auto__,active_viz.scale.time_scale.unit_nice_values.call(null,data__9775__auto__),null,null,null));
}));


/**
 * Lens for the `nice-values` field from a [[Unit]] record. See [[active-viz.scale.time-scale/make-unit]].
 */
active_viz.scale.time_scale.unit_nice_values = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.time_scale.Unit)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (unit-nice-values)."));
}

return rec__9774__auto__.nice_values;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.time_scale.Unit(active_viz.scale.time_scale.unit_time_unit.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_time_constructor.call(null,data__9775__auto__),active_viz.scale.time_scale.unit_approx_ms.call(null,data__9775__auto__),v__9776__auto__,null,null,null));
}));



active_viz.scale.time_scale.millisecond = (1);
active_viz.scale.time_scale.second_ms = ((1000) * active_viz.scale.time_scale.millisecond);
active_viz.scale.time_scale.minute_ms = ((60) * active_viz.scale.time_scale.second_ms);
active_viz.scale.time_scale.hour_ms = ((60) * active_viz.scale.time_scale.minute_ms);
active_viz.scale.time_scale.day_ms = ((24) * active_viz.scale.time_scale.hour_ms);
active_viz.scale.time_scale.month_ms = ((30) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.year_ms = ((365) * active_viz.scale.time_scale.day_ms);
active_viz.scale.time_scale.millisecond_nice = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(5),(10),(100),(250),(500),(1000)], null);
active_viz.scale.time_scale.second_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(10),(20),(30),(60)], null);
active_viz.scale.time_scale.minute_nice = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(5),(10),(15),(30),(60)], null);
active_viz.scale.time_scale.hour_nice = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(24)], null);
active_viz.scale.time_scale.day_nice = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(4),(6),(8),(10),(15),(30),182.5,(365)], null);
active_viz.scale.time_scale.month_nice = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(3)], null);
active_viz.scale.time_scale.year_nice = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2),(3),(4),(5),(6),(7),(8),(9)], null);
active_viz.scale.time_scale.year_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.year,cljs_time.core.years,active_viz.scale.time_scale.year_ms,active_viz.scale.time_scale.year_nice);
active_viz.scale.time_scale.month_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.month,cljs_time.core.months,active_viz.scale.time_scale.month_ms,active_viz.scale.time_scale.month_nice);
active_viz.scale.time_scale.day_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.day,cljs_time.core.days,active_viz.scale.time_scale.day_ms,active_viz.scale.time_scale.day_nice);
active_viz.scale.time_scale.hour_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.hour,cljs_time.core.hours,active_viz.scale.time_scale.hour_ms,active_viz.scale.time_scale.hour_nice);
active_viz.scale.time_scale.minute_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.minute,cljs_time.core.minutes,active_viz.scale.time_scale.minute_ms,active_viz.scale.time_scale.minute_nice);
active_viz.scale.time_scale.second_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.second,cljs_time.core.seconds,active_viz.scale.time_scale.second_ms,active_viz.scale.time_scale.second_nice);
active_viz.scale.time_scale.ms_unit = active_viz.scale.time_scale.make_unit.call(null,cljs_time.core.milli,cljs_time.core.millis,active_viz.scale.time_scale.millisecond,active_viz.scale.time_scale.millisecond_nice);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {active_viz.scale.types.ScaleFn}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
active_viz.scale.time_scale.TimeScaleParams = (function (linear_scale,__meta,__extmap,__hash){
this.linear_scale = linear_scale;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__9707__auto__,k__9708__auto__){
var self__ = this;
var this__9707__auto____$1 = this;
return this__9707__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__9708__auto__,null);
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__9709__auto__,k10548,else__9710__auto__){
var self__ = this;
var this__9709__auto____$1 = this;
var G__10552 = k10548;
var G__10552__$1 = (((G__10552 instanceof cljs.core.Keyword))?G__10552.fqn:null);
switch (G__10552__$1) {
case "linear-scale":
return self__.linear_scale;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k10548,else__9710__auto__);

}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__9717__auto__,writer__9718__auto__,opts__9719__auto__){
var self__ = this;
var this__9717__auto____$1 = this;
var pr_pair__9720__auto__ = ((function (this__9717__auto____$1){
return (function (keyval__9721__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,cljs.core.pr_writer,""," ","",opts__9719__auto__,keyval__9721__auto__);
});})(this__9717__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__9718__auto__,pr_pair__9720__auto__,"#active-viz.scale.time-scale.TimeScaleParams{",", ","}",opts__9719__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),self__.linear_scale],null))], null),self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__10547){
var self__ = this;
var G__10547__$1 = this;
return (new cljs.core.RecordIter((0),G__10547__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__9705__auto__){
var self__ = this;
var this__9705__auto____$1 = this;
return self__.__meta;
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__9702__auto__){
var self__ = this;
var this__9702__auto____$1 = this;
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__9711__auto__){
var self__ = this;
var this__9711__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__9703__auto__){
var self__ = this;
var this__9703__auto____$1 = this;
var h__4061__auto__ = self__.__hash;
if(!((h__4061__auto__ == null))){
return h__4061__auto__;
} else {
var h__4061__auto____$1 = ((function (h__4061__auto__,this__9703__auto____$1){
return (function (coll__9704__auto__){
return (1743401513 ^ cljs.core.hash_unordered_coll.call(null,coll__9704__auto__));
});})(h__4061__auto__,this__9703__auto____$1))
.call(null,this__9703__auto____$1);
self__.__hash = h__4061__auto____$1;

return h__4061__auto____$1;
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this10549,other10550){
var self__ = this;
var this10549__$1 = this;
return ((!((other10550 == null))) && ((this10549__$1.constructor === other10550.constructor)) && (cljs.core._EQ_.call(null,this10549__$1.linear_scale,other10550.linear_scale)) && (cljs.core._EQ_.call(null,this10549__$1.__extmap,other10550.__extmap)));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$ = cljs.core.PROTOCOL_SENTINEL;

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$call$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
var param_ms = cljs_time.coerce.to_long.call(null,param);
return active_viz.scale.types.call.call(null,active_viz.scale.types.scale_params.call(null,self__.linear_scale),self__.linear_scale,param_ms);
});

active_viz.scale.time_scale.TimeScaleParams.prototype.active_viz$scale$types$ScaleFn$call_inverse$arity$3 = (function (_,___$1,param){
var self__ = this;
var ___$2 = this;
return cljs_time.coerce.from_long.call(null,active_viz.scale.types.call_inverse.call(null,active_viz.scale.types.scale_params.call(null,self__.linear_scale),self__.linear_scale,param));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__9700__auto__,k__9701__auto__){
var self__ = this;
var this__9700__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),null], null), null),k__9701__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__9700__auto____$1),self__.__meta),k__9701__auto__);
} else {
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__9701__auto__)),null));
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__9698__auto__,k__9699__auto__,G__10547){
var self__ = this;
var this__9698__auto____$1 = this;
var pred__10553 = cljs.core.keyword_identical_QMARK_;
var expr__10554 = k__9699__auto__;
if(cljs.core.truth_(pred__10553.call(null,new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),expr__10554))){
return (new active_viz.scale.time_scale.TimeScaleParams(G__10547,self__.__meta,self__.__extmap,null));
} else {
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__9699__auto__,G__10547),null));
}
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__9715__auto__){
var self__ = this;
var this__9715__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221),self__.linear_scale,null))], null),self__.__extmap));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__9706__auto__,G__10547){
var self__ = this;
var this__9706__auto____$1 = this;
return (new active_viz.scale.time_scale.TimeScaleParams(self__.linear_scale,G__10547,self__.__extmap,self__.__hash));
});

active_viz.scale.time_scale.TimeScaleParams.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__9712__auto__,entry__9713__auto__){
var self__ = this;
var this__9712__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__9713__auto__)){
return this__9712__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__9713__auto__,(0)),cljs.core._nth.call(null,entry__9713__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__9712__auto____$1,entry__9713__auto__);
}
});

active_viz.scale.time_scale.TimeScaleParams.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"linear-scale","linear-scale",91410306,null)], null);
});

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$type = true;

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$ctorPrSeq = (function (this__9793__auto__){
return (new cljs.core.List(null,"active-viz.scale.time-scale/TimeScaleParams",null,(1),null));
});

active_viz.scale.time_scale.TimeScaleParams.cljs$lang$ctorPrWriter = (function (this__9793__auto__,writer__9794__auto__){
return cljs.core._write.call(null,writer__9794__auto__,"active-viz.scale.time-scale/TimeScaleParams");
});

if(cljs.core._EQ_.call(null,false,new cljs.core.Keyword(null,"arrow-constructor?","arrow-constructor?",-1068727936).cljs$core$IFn$_invoke$arity$1(null))){
} else {
/**
 * Positional factory function for active-viz.scale.time-scale/TimeScaleParams.
 */
active_viz.scale.time_scale.__GT_TimeScaleParams = (function active_viz$scale$time_scale$__GT_TimeScaleParams(linear_scale){
return (new active_viz.scale.time_scale.TimeScaleParams(linear_scale,null,null,null));
});
}

/**
 * Factory function for active-viz.scale.time-scale/TimeScaleParams, taking a map of keywords to field values.
 */
active_viz.scale.time_scale.map__GT_TimeScaleParams = (function active_viz$scale$time_scale$map__GT_TimeScaleParams(G__10551){
var extmap__9615__auto__ = (function (){var G__10556 = cljs.core.dissoc.call(null,G__10551,new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221));
if(cljs.core.record_QMARK_.call(null,G__10551)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__10556);
} else {
return G__10556;
}
})();
return (new active_viz.scale.time_scale.TimeScaleParams(new cljs.core.Keyword(null,"linear-scale","linear-scale",-1549121221).cljs$core$IFn$_invoke$arity$1(G__10551),null,cljs.core.not_empty.call(null,extmap__9615__auto__),null));
});

/**
 * Is object a `TimeScaleParams` record? See [[active-viz.scale.time-scale/make-time-scale-params]].
 */
active_viz.scale.time_scale.time_scale_params_QMARK_ = (function active_viz$scale$time_scale$time_scale_params_QMARK_(x__9795__auto__){
return (x__9795__auto__ instanceof active_viz.scale.time_scale.TimeScaleParams);
});

/**
 * Construct a `TimeScaleParams` record.
 * 
 * `linear-scale`: access via [[active-viz.scale.time-scale/time-scale-params-linear-scale]]
 */
active_viz.scale.time_scale.make_time_scale_params = (function active_viz$scale$time_scale$make_time_scale_params(linear_scale){
return (new active_viz.scale.time_scale.TimeScaleParams(linear_scale,null,null,null));
});


/**
 * Lens for the `linear-scale` field from a [[TimeScaleParams]] record. See [[active-viz.scale.time-scale/make-time-scale-params]].
 */
active_viz.scale.time_scale.time_scale_params_linear_scale = active.clojure.lens.lens.call(null,(function (rec__9774__auto__){
if((rec__9774__auto__ instanceof active_viz.scale.time_scale.TimeScaleParams)){
} else {
throw (new Error("Wrong record type (rec__9774__auto__) passed to accessor (time-scale-params-linear-scale)."));
}

return rec__9774__auto__.linear_scale;
}),(function (data__9775__auto__,v__9776__auto__){
return (new active_viz.scale.time_scale.TimeScaleParams(v__9776__auto__,null,null,null));
}));



active_viz.scale.time_scale.make_time_scale = (function active_viz$scale$time_scale$make_time_scale(p__10558,p__10559){
var vec__10560 = p__10558;
var domain_min = cljs.core.nth.call(null,vec__10560,(0),null);
var domain_max = cljs.core.nth.call(null,vec__10560,(1),null);
var vec__10563 = p__10559;
var range_min = cljs.core.nth.call(null,vec__10563,(0),null);
var range_max = cljs.core.nth.call(null,vec__10563,(1),null);
var start_date_ms = cljs_time.coerce.to_long.call(null,domain_min);
var end_date_ms = cljs_time.coerce.to_long.call(null,domain_max);
var linear_scale = active_viz.scale.linear_scale.make_linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_date_ms,end_date_ms], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [range_min,range_max], null));
return active_viz.scale.types.make_scale.call(null,domain_min,domain_max,range_min,range_max,active_viz.scale.time_scale.make_time_scale_params.call(null,linear_scale),active_viz.scale.types.nop);
});
active_viz.scale.time_scale.find_nice_value = (function active_viz$scale$time_scale$find_nice_value(interval_ms,num_ticks,unit){
return cljs.core.second.call(null,(function (){var unit_ms = active_viz.scale.time_scale.unit_approx_ms.call(null,unit);
var nice_values = active_viz.scale.time_scale.unit_nice_values.call(null,unit);
var score_fn = ((function (unit_ms,nice_values){
return (function (nice_val){
return Math.abs((num_ticks - (interval_ms / (nice_val * unit_ms))));
});})(unit_ms,nice_values))
;
return cljs.core.reduce.call(null,((function (unit_ms,nice_values,score_fn){
return (function (p__10566,nice_value){
var vec__10567 = p__10566;
var best_score = cljs.core.nth.call(null,vec__10567,(0),null);
var best_nice_value = cljs.core.nth.call(null,vec__10567,(1),null);
var score = score_fn.call(null,nice_value);
if(cljs.core.truth_((function (){var and__3938__auto__ = best_score;
if(cljs.core.truth_(and__3938__auto__)){
return (best_score > score);
} else {
return and__3938__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [score,nice_value], null);
} else {
if(cljs.core.truth_(best_score)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [best_score,best_nice_value], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [score,nice_value], null);

}
}
});})(unit_ms,nice_values,score_fn))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),nice_values);
})());
});
active_viz.scale.time_scale.t_GT__EQ_ = (function active_viz$scale$time_scale$t_GT__EQ_(a,b){
var a_ms = cljs_time.coerce.to_long.call(null,a);
var b_ms = cljs_time.coerce.to_long.call(null,b);
return (a_ms >= b_ms);
});
active_viz.scale.time_scale.time_ceiling = (function active_viz$scale$time_scale$time_ceiling(t,unit,constructor$){
if(cljs.core._EQ_.call(null,cljs_time.coerce.to_long.call(null,cljs_time.core.floor.call(null,t,unit)),cljs_time.coerce.to_long.call(null,t))){
return t;
} else {
return cljs_time.core.floor.call(null,cljs_time.core.plus.call(null,t,constructor$.call(null,(1))),unit);
}
});
active_viz.scale.time_scale.create_ticks = (function active_viz$scale$time_scale$create_ticks(start_date,end_date,num_ticks,unit){
var constructor$ = active_viz.scale.time_scale.unit_time_constructor.call(null,unit);
var nice_values = active_viz.scale.time_scale.unit_nice_values.call(null,unit);
var time_unit = active_viz.scale.time_scale.unit_time_unit.call(null,unit);
var floor = cljs_time.core.floor.call(null,start_date,time_unit);
var ceiling = active_viz.scale.time_scale.time_ceiling.call(null,end_date,time_unit,constructor$);
var nice_value = active_viz.scale.time_scale.find_nice_value.call(null,(cljs_time.coerce.to_long.call(null,ceiling) - cljs_time.coerce.to_long.call(null,floor)),num_ticks,unit);
var acc = (new cljs.core.List(null,floor,null,(1),null));
while(true){
var next_date = cljs_time.core.plus.call(null,cljs.core.first.call(null,acc),constructor$.call(null,nice_value));
var next_dates = cljs.core.cons.call(null,next_date,acc);
if(cljs.core.truth_(active_viz.scale.time_scale.t_GT__EQ_.call(null,next_date,end_date))){
return next_dates;
} else {
var G__10570 = next_dates;
acc = G__10570;
continue;
}
break;
}
});
active_viz.scale.time_scale.time_scale__GT_ticks = (function active_viz$scale$time_scale$time_scale__GT_ticks(scale,unit,num_ticks){
var start_date = active_viz.scale.types.scale_domain_min.call(null,scale);
var end_date = active_viz.scale.types.scale_domain_max.call(null,scale);
return active_viz.scale.time_scale.create_ticks.call(null,start_date,end_date,num_ticks,unit);
});
active_viz.scale.time_scale.year_formatter = cljs_time.format.formatter.call(null,"yyyy");
active_viz.scale.time_scale.format_year = (function active_viz$scale$time_scale$format_year(dt){
if(cljs.core._EQ_.call(null,(1),cljs_time.core.month.call(null,dt))){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.year_formatter,dt);
} else {
return "";
}
});
active_viz.scale.time_scale.month_formatter = cljs_time.format.formatter.call(null,"MM/yyyy");
active_viz.scale.time_scale.format_month = (function active_viz$scale$time_scale$format_month(dt){
return cljs_time.format.unparse.call(null,active_viz.scale.time_scale.month_formatter,dt);
});
active_viz.scale.time_scale.recommend_unit = (function active_viz$scale$time_scale$recommend_unit(start_date,end_date){
var interval = (cljs_time.coerce.to_long.call(null,end_date) - cljs_time.coerce.to_long.call(null,start_date));
var gt = ((function (interval){
return (function (v){
return (interval > v);
});})(interval))
;
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.month_ms * (36))))){
return active_viz.scale.time_scale.year_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.day_ms * (90))))){
return active_viz.scale.time_scale.month_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.hour_ms * (72))))){
return active_viz.scale.time_scale.day_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.minute_ms * (180))))){
return active_viz.scale.time_scale.hour_unit;
} else {
if(cljs.core.truth_(gt.call(null,(active_viz.scale.time_scale.second_ms * (180))))){
return active_viz.scale.time_scale.minute_unit;
} else {
if(cljs.core.truth_(gt.call(null,(3000)))){
return active_viz.scale.time_scale.second_unit;
} else {
return active_viz.scale.time_scale.ms_unit;

}
}
}
}
}
}
});

//# sourceMappingURL=time_scale.js.map
