// Compiled by ClojureScript 1.10.339 {}
goog.provide('active_viz.ticks');
goog.require('cljs.core');
/**
 * Calculates an interval for ticks and a step-width.
 *   Uses the Wilkinson Labelling Algorithm as defined in
 *   "Wilkinson, L. (2005) The Grammar of Graphics, Springer-Verlag New York, Inc."
 * 
 *   Takes
 * 
 *   * `dmin`, a lower bound of the value range
 *   * `dmax`, an upper bound of the value range
 *   * `m` is the target number of ticks in value range. This is a rough suggestion and will the real number of ticks is determined in the range `mrange`
 *   * `q` (optional), a vector of nice values, which are used to calculate intra-tick distance
 *   * `min-coverage` (optional) as a algorithm parameter, determining a minimum of interval coverage, defaults to 0.8
 *   * `mrange` (optional) the range in which the number of ticks is determined. This defaults to `(/ m 2)` and `(* m 3)`
 * 
 * 
 *   Returns a map containing `:lmin`, `:lmax` and `:lstep`, where lmin is the lower bound of
 *   the interval lmax the upperbound and lstep the step-width.
 *   Also returns a score value in `:score`. The higher the score the better the result. 
 */
active_viz.ticks.nice_ticks = (function active_viz$ticks$nice_ticks(var_args){
var G__9866 = arguments.length;
switch (G__9866) {
case 3:
return active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$3 = (function (dmin,dmax,m){
return active_viz.ticks.nice_ticks.call(null,dmin,dmax,m,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(5),(2),2.5,(3),(4),1.5,(7),(6),(8),(9),(10)], null));
});

active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$4 = (function (dmin,dmax,m,q){
return active_viz.ticks.nice_ticks.call(null,dmin,dmax,m,q,0.8,cljs.core.range.call(null,Math.max(Math.floor((m / (2))),(2)),Math.ceil(((3) * m))));
});

active_viz.ticks.nice_ticks.cljs$core$IFn$_invoke$arity$6 = (function (dmin,dmax,m,q,min_coverage,mrange){
return cljs.core.reduce.call(null,(function (best,k){
var result = active_viz.ticks.nice_ticks_STAR_.call(null,dmin,dmax,k,q,min_coverage,mrange,m);
if(((((!((result == null))) && ((best == null)))) || ((new cljs.core.Keyword(null,"score","score",-1963588780).cljs$core$IFn$_invoke$arity$1(result) > new cljs.core.Keyword(null,"score","score",-1963588780).cljs$core$IFn$_invoke$arity$1(best))))){
return result;
} else {
return best;
}
}),null,mrange);
});

active_viz.ticks.nice_ticks.cljs$lang$maxFixedArity = 6;

active_viz.ticks.nice_ticks_STAR_ = (function active_viz$ticks$nice_ticks_STAR_(min,max,k,q,min_coverage,mrange,m){
var q__$1 = cljs.core.vec.call(null,q);
var range_vals = (max - min);
var intervals = (k - (1));
var granularity = ((Math.abs((k - m)) / m) - (1));
var delta = (range_vals / intervals);
var base = Math.floor(Math.log10(delta));
var dbase = Math.pow((10),base);
return cljs.core.reduce.call(null,((function (q__$1,range_vals,intervals,granularity,delta,base,dbase){
return (function (best,i){
var tdelta = (cljs.core.get.call(null,q__$1,i) * dbase);
var tmin = (tdelta * Math.floor((min / tdelta)));
var tmax = (tmin + (intervals * tdelta));
if((((tmin <= min)) && ((tmax >= max)))){
var p = (((((tmin <= (0))) && ((tmax >= (0)))))?(1):(0));
var roundness = ((1) - (((i - (1)) - p) / cljs.core.count.call(null,q__$1)));
var coverage = ((max - min) / (tmax - tmin));
if((coverage > min_coverage)){
var tnice = ((granularity + roundness) + coverage);
if((((best == null)) || ((tnice > new cljs.core.Keyword(null,"score","score",-1963588780).cljs$core$IFn$_invoke$arity$1(best))))){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"lmin","lmin",2139111947),tmin,new cljs.core.Keyword(null,"lmax","lmax",-1390660950),tmax,new cljs.core.Keyword(null,"lstep","lstep",-1243990033),tdelta,new cljs.core.Keyword(null,"score","score",-1963588780),tnice], null);
} else {
return best;
}
} else {
return best;
}
} else {
return best;
}
});})(q__$1,range_vals,intervals,granularity,delta,base,dbase))
,null,cljs.core.range.call(null,(0),cljs.core.count.call(null,q__$1)));
});

//# sourceMappingURL=ticks.js.map
