(ns reacl-c-basics.cljss
  (:require #?(:clj [cljss.core :as css])
            #?(:clj [cljss.builder :as builder])
            #?(:cljs [cljss.core :as css :include-macros true])
            [reacl-c.core :as c :include-macros true]
            [reacl-c.dom :as dom]))

#?(:clj (defmacro defstyled [name tag styles]
          (let [cls-name#       (css/var->cls-name name)
                cmp-name#       (css/var->cmp-name name)
                [tag# static# vals# attrs#] (css/->styled tag styles cls-name#)
                create-element# `#(apply ~tag %1 %2)]
            `(do
               (def ~name
                 (reacl-c-basics.cljss/styled ~cls-name# ~static# ~vals# ~attrs# ~create-element#))
               ;; React specific - could use named items?
               #_(set! ~name ~'-displayName ~cmp-name#)))))

#?(:cljs
   ;; defines a styled function, which used map? to recognize attributes :-/ can't use that directly.
   #_(css/make-styled)

   (defn ^:no-doc styled [cls static vars attrs create-element]
     (let [internal (css/-styled cls static vars attrs create-element)]
       (fn [& args]
         (if (dom/dom-attributes? (first args))
           (apply internal args)
           (apply internal {} args))))))

;; add https://github.com/clj-commons/cljss#css-attribute ? see https://github.com/clj-commons/cljss/blob/master/src/sablono/cljss_compiler.clj
;; -> into the core?

#?(:clj (defmacro css-1 [styles]
          (let [cls (str "css-" (hash styles))]
            `(css/css ~@(builder/build-styles cls styles)))))

#?(:clj (defmacro css [& styles]
          ;; TODO: the whole string should be constructible at compile time.
          `(apply str (interpose " " (list ~@(map (fn [st]
                                                    (if (string? st)
                                                      st
                                                      `(css-1 ~st)))
                                                  styles))))))
