(ns reacl-c.interop.native
  (:require [reacl-c.core :as c :include-macros true]
            [reacl-c.interop.react :as r]
            [reacl-c.impl.react0 :as r0]
            [reacl-c.main.wc :as wc]
            [active.clojure.functions :as f]))

;; There should a few general ways for native components:
;; 1. create as a node, to be appended to an existing node (container)  (like webcomponents?)
;;   1b. create a custom object, with a method to access its node to be appended.
;; 2. create a custom object by passing the container node to it.  

;; 3. Functionality that only operates on existing nodes. (example popper.js, carousel-js ?)

(def ^:private native-object-class
  (r0/make-class "reacl-c/native/object"
                 {"render"
                  (fn [this] (r0/fragment nil))

                  "getSnapshotBeforeUpdate"
                  (fn [this ^js prev-props ^js prev-state]
                    (js/console.log "snapshot before")
                    (if (not= (.-create prev-props) (.-create ^js (.-props this)))
                      ;; recreate thing instead
                      (do ((.-destroy prev-props) (.-current ^js (.-props this)))
                          ;; new thing returned as the snapshot value:
                          ;; TODO: assert non-nil
                          ((.-create ^js (.-props this)) (.-attrs ^js (.-props this))))
                      ;; normal before-update
                      ((.-beforeUpdate ^js (.-props this)) (.-current ^js (.-props this)) (.-attrs prev-props) (.-attrs ^js (.-props this)))
                      ))

                  "componentDidMount"
                  (fn [this]
                    (let [attrs (.-attrs ^js (.-props this))
                          inject (.-inject ^js (.-props this))
                          thing ((.-create ^js (.-props this)) attrs)]
                      (inject (constantly (c/return :state thing)))))

                  "componentDidUpdate"
                  (fn [this ^js prev-props ^js prev-state snapshot]
                    (js/console.log "did update")
                    (if (not= (.-create prev-props) (.-create ^js (.-props this)))
                      ;; getSnapshotBeforeUpdate created new thing, don't call update
                      (let [inject (.-inject ^js (.-props this))
                            thing snapshot]
                        (inject (constantly (c/return :state thing))))
                      
                      ;; normal update
                      ((.-update ^js (.-props this)) (.-current ^js (.-props this)) (.-attrs prev-props) (.-attrs ^js (.-props this)) snapshot)))

                  "componentWillUnmount"
                  (fn [this]
                    (when-let [thing (.-current ^js (.-props this))]
                      ((.-destroy ^js (.-props this)) thing)))

                  "shouldComponentUpdate"
                  (fn [this ^js next-props next-state]
                    ;; if attrs change, or create changes.
                    (or (not= (.-attrs next-props) (.-attrs ^js (.-props this)))
                        (not= (.-create next-props) (.-create ^js (.-props this)))))
                  }))

#_(defn- ignore-attrs [f attrs]
  (f))

;; TODO: how to call methods on the thing - presumably as reaction to messages... thing as state maybe?

#_(def ^:private with-dom-node-class
  (r0/make-class "reacl-c/with-dom-node"
                 {"render"
                  (fn [this]
                    (.-item ))

                  "componentDidMount"
                  (fn [this]
                    (.setState this #js {:node (.-current (.-cref (.-props this)))})
                    )
                  }
                 )
    )

#_(r0/make-class "reacl-c/native/with-dom-node"
               {"render"
                (fn [this]
                  #_(react/render item binding ref key)
                  (r0/create-element "div" #js {:ref ...})
                  )
                }
               )

#_(defn with-dom-node [dom-item f]
  )

#_(defn with-parent-node [dom-item f]
  
  )

(defn object
  "Returns an invisible item that will set its state to the object created by
  `create` which can be modified imperatively during its lifecycle.
  
  (create attrs) => thing
  (before-update thing prev-attrs new-attrs) => snapshot, something derived from thing.
  (update thing prev-attrs new-attrs) ... mutation on thing.
  (delete thing) ... same
  "
  ([attrs create before-update update destroy]
   (c/with-async
     (fn [inject]
       (c/dynamic (fn [thing]
                    (r/lift native-object-class #js {:attrs attrs
                                                     :current thing
                                                     :inject inject
                                                     :create create
                                                     :beforeUpdate before-update
                                                     :update update
                                                     :destroy destroy}))))))
  ([attrs create update destroy]
   (object attrs create (f/constantly nil) update destroy))
  ([attrs create update]
   (object attrs create (f/constantly nil) update))
  ([attrs create]
   (object attrs create (f/constantly nil))))


#_(defn node [attrs create update destroy]
    )

#_(defonce node-c (wc/define! "reacl-c-node-c"
                  (-> (fn [attrs]
                        (println "xxx" (get attrs "node"))
                        
                        )
                      (wc/data-property "node" nil)
                      )
                  ))

#_(defn node [n]
  
  )
