(ns custom-oracledb
  (:require [sqlosure.backend :as backend]
            [sqlosure.backends.oracledb :as oracledb]
            [sqlosure.type :as t]
            [sqlosure.type-implementation :as ti])
  (:import [java.sql PreparedStatement ResultSet]))

(defn read-boolean
  [^ResultSet rs ^Long ix]
  (zero? (.getInt rs ix)))

(defn write-boolean
  [^PreparedStatement stmt ^Long ix val]
  (.setInt stmt ix (if val 0 1)))

(def implementation
  (-> oracledb/implementation
      (backend/reify-type-implementation t/boolean% ti/type-implementation-from-sql read-boolean)
      (backend/reify-type-implementation t/boolean% ti/type-implementation-to-sql write-boolean)))
