(ns sqlosure.config
  "Configuration for SQLosure."
  (:require [active.clojure.config :as config]))

(def db-host
  (config/setting
   :host
   "The hostname/ip the database system is hosted on."
   config/string-range))

(def db-port
  (config/setting
   :port
   "The port host is listening on."
   (config/integer-between-range 1024 49151 5432)))

(def db-name
  (config/setting
   :name
   "The name of the database (i.e. \"xe\")."
   config/string-range))

(def db-table-space
  (config/setting
   :table-space
   "The table-space tables are stored under."
   config/string-range))

(def db-user
  (config/setting
   :user
   "The user-name of the user for this database."
   config/string-range))

(def db-password
  (config/setting
   :password
   "The password of the user for this database."
   config/string-range))

(def db-backends #{:oracledb :h2 :postgres :base})

(def db-backend
  (config/setting
   :backend
   "The database-system in use. One of #{:oracle :h2 :postgres}."
   (config/one-of-range db-backends :other)))

(def sqlosure-section
  (config/section
   :sqlosure
   (config/schema "The SQLosure configuration schema."
                  db-host
                  db-port
                  db-name
                  db-table-space
                  db-user
                  db-password
                  db-backend)))
