(ns sqlosure.playground
  (:require [active.clojure.monad :as monad]
            [sqlosure.core :as sql]
            [sqlosure.lang :as db]

            [sqlosure.runner.embedded :as emb]))

(defrecord Person [id first-name])

(def person-table
  (sql/table "person" [["id" sql/$integer-t]
                       ["firstName" sql/$string-t]]))


(def query-all (sql/query [t (sql/<- person-table)]
                          (sql/project t)))

(sql/run-db (emb/command-config {"person" #{{"id" 1 "firstName" "Marco"}}}) (db/read! query-all))


(-> (sql/query [outer (sql/embed (sql/query [inner (sql/embed person-table)]
                                            (sql/project inner)))]
               (sql/project outer))
    sql/put-query)
