(ns leiningen.deploy-war
  (:require [leiningen.deploy :as dep]
            [leiningen.pom :as pom]
            [leiningen.core.main :as main]))

(defn deploy-war
  "Deploy WAR file generated by ring to remote repository.
Example:

      $ lein deploy-war

This task functions by delegating to the built-in Leiningen deploy task."
  [project & args]
  (let [identifier (str (symbol (:group project) (:name project)))
        version (:version project)
        uberwar-name (get-in project [:ring :uberwar-name])
        war-file (str "target/" uberwar-name)
        repository (if (pom/snapshot? project)
                     "snapshots"
                     "releases")]
    (main/debug "deploying" war-file "to" repository)
    (dep/deploy project repository identifier version war-file)))
