(ns de.npexception.spacetraders-clj.core-with-token
  "Autogenerated namespace where token-taking functions instead take it from the system environment."
  (:require [de.npexception.spacetraders-clj.core :as core]))

(def ^:private token (delay (System/getenv "SPACE_TRADERS_TOKEN")))

(def claim-username!
  "Claim a username and get a token"
  core/claim-username!)

(def game-status
  "Use to determine whether the server is alive"
  core/game-status)

(defn available-goods
  "Get available goods"
  []
  (apply core/available-goods @token []))

(defn available-loans
  "Get available loans"
  []
  (apply core/available-loans @token []))

(defn available-ships
  "Get info on available ships"
  []
  (apply core/available-ships @token []))

(defn available-structures
  "Get available structures"
  []
  (apply core/available-structures @token []))

(defn buy-ship!
  "Buy a new ship (takes either a ship type string, or known ship map)"
  [location ship]
  (apply core/buy-ship! @token location ship []))

(defn create-flight-plan!
  "Submit a new flight plan"
  [ship destination]
  (apply core/create-flight-plan! @token ship destination []))

(defn create-structure!
  "Create a new structure"
  [location type]
  (apply core/create-structure! @token location type []))

(defn deposit-goods!
  "Deposit goods to a structure"
  [structure ship good quantity]
  (apply core/deposit-goods! @token structure ship good quantity []))

(defn deposit-goods-to-owned-structure!
  "Deposit goods to a structure you own"
  [structure ship good quantity]
  (apply core/deposit-goods-to-owned-structure! @token structure ship good quantity []))

(defn jettison-cargo!
  "Jettison cargo"
  [ship good quantity]
  (apply core/jettison-cargo! @token ship good quantity []))

(defn leaderboard
  "Use to see the current net worth of the top players"
  []
  (apply core/leaderboard @token []))

(defn location-info
  "Get info on a location"
  [location]
  (apply core/location-info @token location []))

(defn location-marketplace
  "Get info on a location's marketplace"
  [location]
  (apply core/location-marketplace @token location []))

(defn location-ships
  "Get the ships at a location"
  [location]
  (apply core/location-ships @token location []))

(defn location-structures
  "Get the structures at a location"
  [location]
  (apply core/location-structures @token location []))

(defn my-account
  "Get information on your account"
  []
  (apply core/my-account @token []))

(defn my-flight-plan-info
  "Get info on an existing flight plan"
  [flight-plan]
  (apply core/my-flight-plan-info @token flight-plan []))

(defn my-loans
  "Get your loans"
  []
  (apply core/my-loans @token []))

(defn my-ship-info
  "Get your ship info"
  [ship]
  (apply core/my-ship-info @token ship []))

(defn my-ships
  "Get your ships"
  []
  (apply core/my-ships @token []))

(defn my-structure-info
  "Use to see a specific structure you own"
  [structure]
  (apply core/my-structure-info @token structure []))

(defn my-structures
  "Use to see all of your structures"
  []
  (apply core/my-structures @token []))

(defn pay-off-loan!
  "Pay off your loan"
  [loan]
  (apply core/pay-off-loan! @token loan []))

(defn place-purchase-order!
  "Place a new purchase order"
  [ship good quantity]
  (apply core/place-purchase-order! @token ship good quantity []))

(defn place-sell-order!
  "Place a new sell order"
  [ship good quantity]
  (apply core/place-sell-order! @token ship good quantity []))

(defn sell-ship!
  "Scrap your ship for credits"
  [ship]
  (apply core/sell-ship! @token ship []))

(defn star-systems
  "Use to get basic info about star systems in the game"
  []
  (apply core/star-systems @token []))

(defn structure-info
  "See specific structure (ship must be docked at same location?)"
  [structure]
  (apply core/structure-info @token structure []))

(defn system-docked-ships
  "Get info on a system's docked ships"
  [system]
  (apply core/system-docked-ships @token system []))

(defn system-flight-plans
  "Get all active flight plans in the system"
  [system]
  (apply core/system-flight-plans @token system []))

(defn system-info
  "Get systems info"
  [system]
  (apply core/system-info @token system []))

(defn system-locations
  "Get location info for a system"
  [system & [type :as _arg__2]]
  (apply core/system-locations @token system _arg__2))

(defn system-ship-listings
  "Get a list of all ships available to buy in the system"
  [system & [class :as _arg__2]]
  (apply core/system-ship-listings @token system _arg__2))

(defn take-goods!
  "Transfer goods from your structure to a ship"
  [structure ship good quantity]
  (apply core/take-goods! @token structure ship good quantity []))

(defn take-out-loan!
  "Take out a loan"
  [loan]
  (apply core/take-out-loan! @token loan []))

(defn transfer-cargo!
  "Transfer cargo between ships"
  [from-ship to-ship good quantity]
  (apply core/transfer-cargo! @token from-ship to-ship good quantity []))

(defn warp-jump!
  "Attempt a warp jump"
  [ship]
  (apply core/warp-jump! @token ship []))
