/*
 * Decompiled with CFR 0.152.
 */
package de.paymill.net;

import de.paymill.PaymillException;
import de.paymill.net.JsonDecoder;
import de.paymill.net.UrlEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import sun.misc.BASE64Encoder;

public class HttpClient {
    protected URL apiUrl;
    protected String apiKey;
    protected UrlEncoder urlEncoder;
    protected JsonDecoder jsonDecoder;

    public HttpClient(String apiUrl, String apiKey) {
        this(HttpClient.urlObject(apiUrl), apiKey);
    }

    public HttpClient(URL apiUrl, String apiKey) {
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.urlEncoder = new UrlEncoder();
        this.jsonDecoder = new JsonDecoder();
    }

    private static URL urlObject(String url) {
        try {
            return new URL(url);
        }
        catch (IOException ex) {
            throw new PaymillException("Invalid url provided: %s", url);
        }
    }

    public <T> List<T> getList(String resource, Map<String, Object> params, Type listType) {
        return (List)this.request(resource, params, Method.GET, listType);
    }

    public <T> T get(String resource, String id, Class<T> resultClass) {
        return this.request(this.appendId(resource, id), null, Method.GET, resultClass);
    }

    public <T> T post(String resource, Object model, Class<T> resultClass) {
        return this.request(resource, model, Method.POST, resultClass);
    }

    public <T> T put(String resource, String id, Object model, Class<T> resultClass) {
        return this.request(this.appendId(resource, id), model, Method.PUT, resultClass);
    }

    public void delete(String resource, String id) {
        this.request(this.appendId(resource, id), null, Method.DELETE, null);
    }

    public <T> T request(String path, Object params, Method method, Type resultType) {
        URL url = this.getResourceUrl(path);
        HttpURLConnection connection = this.createConnection(url, params, method);
        try {
            int code = connection.getResponseCode();
            if (code >= 200 && code < 300) {
                String body = this.readResponseBody(connection.getInputStream());
                return this.jsonDecoder.decode(body, resultType);
            }
            String body = this.readResponseBody(connection.getErrorStream());
            throw this.jsonDecoder.decodeError(body);
        }
        catch (IOException ex) {
            throw new PaymillException("Error connecting to the api", (Throwable)ex, new Object[0]);
        }
    }

    protected String appendId(String resource, Object identifier) {
        if (identifier == null) {
            return resource;
        }
        String identifierString = identifier.toString();
        if (resource.charAt(resource.length() - 1) == '/') {
            return resource + identifierString;
        }
        return resource + '/' + identifierString;
    }

    protected HttpURLConnection createConnection(URL url, Object params, Method method) {
        String query = null;
        if (params != null) {
            query = this.urlEncoder.encode(params);
        }
        if (query != null && (method == Method.GET || method == Method.DELETE)) {
            url = HttpClient.urlObject(url.toString() + '?' + query);
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method.name());
            if (this.apiKey != null) {
                this.setAuthentication(connection);
            }
            if (query != null && method != Method.GET && method != Method.DELETE) {
                connection.setDoOutput(true);
                connection.getOutputStream().write(query.getBytes());
            }
            return connection;
        }
        catch (IOException ex) {
            throw new PaymillException("Error opening connection", (Throwable)ex, new Object[0]);
        }
    }

    protected void setAuthentication(HttpURLConnection connection) {
        String authInfo = this.apiKey + ":";
        BASE64Encoder encoder = new BASE64Encoder();
        String encodedAuth = encoder.encode(authInfo.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    protected URL getResourceUrl(String resource) {
        StringBuilder url = new StringBuilder().append(this.apiUrl.toString());
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        if (resource.charAt(0) == '/') {
            url.append(resource.substring(1));
        } else {
            url.append(resource);
        }
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new PaymillException("Malformed url: %s", url.toString());
        }
    }

    protected String readResponseBody(InputStream stream) throws IOException {
        String body = new Scanner(stream, "UTF-8").useDelimiter("\\A").next();
        stream.close();
        return body;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

