(ns de.phenomdevel.protocols.idiscord-bot-sender)


;; =============================================================================
;; Protocol

(defprotocol IDiscordBotSender
  (create-message!
    [component channel-id message]
    [component channel-id message embed])

  (edit-message!
    [component channel-id message-id message]
    [component channel-id message-id message embed])

  (create-dm-message!
    [component user-id message]
    [component user-id message embed])

  (delete-message!
    [component channel-id message-id])

  (create-reaction!
    [component channel-id message-id emoji-id])

  (remove-reaction!
    [component channel-id message-id emoji-id user-id])

  (remove-all-reactions!
    [component channel-id message-id])

  (modify-guild-member!
    [component channel-id user-id nick]
    [component channel-id user-id nick roles]))
