(ns de.phenomdevel.components.discord-bot-guild-state
  (:require
   [taoensso.timbre :as log]
   [discljord.events.state :as diss]
   [com.stuartsierra.component :as c]

   [de.phenomdevel.protocols.idiscord-bot-guild-state :as idiscord-bot-guild-state]))


;; =============================================================================
;; Component

(defrecord DiscordBotGuildState [guild-state]
  c/Lifecycle
  (start
    [this]
    (log/info "[DiscordBotGuildState] Started.")
    (->> (atom {})
         (assoc this :guild-state)))

  (stop
    [this]
    (log/info "[DiscordBotGuildState] Stopped.")
    (assoc this :guild-state nil))

  ;; TODO: Implement useful helpers
  idiscord-bot-guild-state/IDiscordBotGuildState
  (get-user-roles
    [this guild-id user-id]
    (get-in @guild-state [::diss/guilds guild-id :members user-id :roles] []))

  (get-emoji-string
    [this guild-id emoji-id]
    (let [{:keys [id name]}
          (->> (get-in @guild-state [::diss/guilds guild-id :emojis])
               (filter (comp #{emoji-id} :id))
               (first))]

      (str name ":" id)))

  ,,,)


;; =============================================================================
;; Public API

(defn new-discord-bot-guild-state
  [config]
  (map->DiscordBotGuildState config))
