# formalicious [![Clojars Project](https://img.shields.io/clojars/v/de.phenomdevel/formalicious.svg)](https://clojars.org/de.phenomdevel/formalicious)

With this library you can build generic html forms using Clojurescirpt and re-frame.

## Get it
Add following dependency to your `project.clj`

```clj
[de.phenomdevel/formalicious "0.1.0alpha"]
```

## Usage
```clj
(:require [de.phenomdevel.formalicious.core :as formalicious])

(def form-spec
  {:data-root
      [:keywords]

    :fields
        {:keyword
              field-specs}})

;; You can render each field and receive a map which is exactly
;; like the map under `fields` within your form-spec
(formalicious/render-fields form-spec)

;; Or you can render the whole form using
(formalicious/render form-spec)

;; Optionally you can provide data which will be used to receive the form-field values
;; If you don't provide data to `formalicious/render` each form-field will
;; subscribe to [:data-root :form-field-id] to receive it's data
(formalicious/render form-spec some-data)

;; By default all form-fields will be wrapped into [:div ,,,]
;; If you want to put the form-fields into another wrapper you can provide it as option
(formalicious/render form-spec some-data {:wrapper [:some-other-html-element]})


```
TODO
### Structure of the input-fields (hiccup)
Most of the input-fields will be rendered as:
```clj
[:div.input-field
  {:class "class-string"}
    [:label "label-string"]
      [input
          {:attributes-map ...}]]
```
### What does each attribute do?
#### Common Attributes
- `:type` (keyword) indicates which input-field should be rendered => Required
- `:label` (string) Holds the label for the rendered input-field
- `:class` (string) Holds any additonal classes which should be applied to the parent html-element of the input-field
- `:placeholder` (string) Holds a placeholder for text-input-fields such as text-inputs or textareas
- `:pos` (integer) This will determine in which order the input-fields will be rendered. If you leave out this key you won't have a guaranteed order
- `:data-path` (either keyword, or vector of keywords) if you don't want the input-field to receive the data of the provided data-map with the id you can specify a data-path. Formalicious will then look into the given data-map and search for a value on the given path. If there is no value it will subscribe to the path provided.
- `:disabled` (either boolean, or function which has to return a boolean value) Determines if the input-field should be disabled or not
#### Select specific attributes
- `:options` (any collection) This collection will used to generate the options for the select input-field
- `:options-path` (keyword or vector of keywords) If no options are provided this will be used to subscribe to a specific data-path
- `:options-label-key` (keyword) Each option will be interpolate so it is represented as map containing `:id` and `:label` at minium. `:options-label-key` will be used to determine which key in the option-map should be used as label.
- `:options-transform` (function) Function which will be applied to each option. E.g `(clojure.string/capitalize)`.
What does the form-spec look like?
```clj
{:data-root
  [:example :form-data]

   :fields
    {:key {,,,}}}
```

### Input: Text

Lets asume we have following form-spec:
```clj
(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:simple-text
     {:type
      :text

      :label
      "Simple Textinput"}}})
```

And we want to render it like this:
```cljs
(defn view
  []
  (let [!form-data
        @(subscribe [:form-data])]

    [:div.form
      [formalicious/render form-spec !form-data]]))
```
This will render a single text-input field. The value will be provided through the `!form-data` which we subscribed on.
The input-field will get it's value of this map through a simple lookup with the input-field-id.
If no id is provided the key which has the field-spec as value will be used as id.

### Input: Password

### Input: Textarea

###

## Example

You want to try it yourself and see how well it can perform?

1. Clone this repo
2. Startup a repl within the repo directory
3. `(user/system-restart!)`
4. `(user/fig-init)`

Now you should be ready to go. Just navigate your browser to `localhost:1338/app` try the forms.

If you want to play around and check the possibilities just go to the cljs/example namespace and have fun.

## License

Copyright © 2017 Kevin Kaiser (PhenomDevel)...

Distributed under the Eclipse Public License either version 1.0.