(ns example.views.select
  (:require
   [cljs.pprint :as pprint]
   [de.phenomdevel.formalicious.core :as formalicious]))

;; =============================================================================
;; Form-Spec

(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:normal-select
    {:type :select
     :label "Select"
     :options ["Eins" "Zwei" "Drei"]
     :order-by :name}}})


;; =============================================================================
;; View

(defn view
  [form-data]
  [:div.panel
   [:pre
    "The form-spec for following example looks like this: \n"
    (with-out-str (pprint/pprint form-spec))]
   [:style
    ".blue-text {color: blue;}"]
   [:h5 "Select Examples"]
   [formalicious/render form-spec form-data]])
