(ns de.phenomdevel.formalicious.util)


;; =============================================================================
;; Collections

(defn deep-merge
  [a b]
  (merge-with (fn [x y]
                (if (map? y)
                  (deep-merge x y) y))
              a b))


;; =============================================================================
;; HTTP Helper

(defn generate-response [data & [status]]
  {:status (or status 200)
   :headers {"Content-Type" "application/edn"}
   :body (pr-str {:success data})})
