(ns example.views.textarea
  (:require
   [de.phenomdevel.formalicious.core :as formalicious]))


;; =============================================================================
;; Form-Spec

(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:normal-textarea
    {:type :textarea
     :label "Textarea"
     :placeholder "Placeholder"}

    :textarea-with-subscription-on-normal-text-input
    {:type :textarea
     :label "Textarea with subscription on `Textinput`'s value"
     :data-path :normal-text-input}}})


;; =============================================================================
;; View

(defn view
  [form-data]
  [:div.panel
   [:style
    ".blue-text {color: blue;}"]
   [:h5 "Textarea Examples"]
   [formalicious/render form-spec form-data]])
