(ns de.phenomdevel.formalicious.components.server
  (:require
   [org.httpkit.server :as httpkit]
   [com.stuartsierra.component :as c]))


;; =============================================================================
;; Component

(defrecord Server [host port
                   app]

  c/Lifecycle

  (start [component]
    (if-not (nil? (:server component))
      component
      (do
        (println (format ";; [Server] Started (PORT: %s)" port))
        (assoc component :server (httpkit/run-server
                                  (:handler app)
                                  {:port port})))))

  (stop [component]
    (if (nil? (:server component))
      component
      (do
        (println ";; [Server] Stopped.")
        ((:server component) :timeout 100)
        (assoc component :server nil)))))


;; =============================================================================
;; Component Constructor

(defn new-server
  [config]
  (map->Server (select-keys config [:host :port])))
