(ns example.views.app
  (:require
   [clojure.string :as str]

   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.core :as core]

   [example.views.text :as text]
   [example.views.textarea :as textarea]
   [example.views.checkbox :as checkbox]
   [example.views.select :as select]))


;; =============================================================================
;; Form-Spec

(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:text
    {:type :text
     :label "Text"}

    :textarea
    {:type :textarea
     :label "Textarea"}

    :select
    {:type :select
     :label "Select"}

    :multiselect
    {:type :multiselect
     :label "Multiselect"
     :options ["One" "Two" "Three" "Four"]}

    :date
    {:type :date
     :label "Date"}

    :password
    {:type :password
     :label "Password"}

    :button
    {:type :button
     :label "Button"
     :class "blue"
     :on-click #(js/window.alert "Button clicked.")}

    :checkbox
    {:type :checkbox
     :label "Checkbox"}

    :radiobutton
    {:type :radiobutton
     :label "Radiobutton"}

    :radiobutton2
    {:type :radiobutton
     :label "Radiobutton2"}

    :radiogroup
    {:type :radiogroup
     :label ""}

    :fieldset
    {:type :fieldset
     :label "Fieldset"}}})


;; =============================================================================
;; View

(defn password-view
  [data spec]
  (let [field-spec
        {:password
         {:type :password
          :label "Password"}}

        f-spec
        (-> spec
            (assoc :fields
                   field-spec))]
    [core/render f-spec data]))

(defn- select-view
  [data spec]
  (let [field-spec
        {:select
         {:type :select
          :label "Select"
          :options [{:id "one" :name "One"}]
          ;; NOTE: This function will be applied to each option in the options-vector
          :options-transform (comp str/reverse :name)}}

        f-spec
        (-> spec
            (assoc :fields
                   field-spec))]

    [core/render f-spec data]))

(defn- multi-select-view
  [data spec]
  (let [field-spec
        {:multiselect
         {:type :multiselect
          :label "Select"
          :options [{:id "1" :name "One"}
                    {:id "2" :name "Two"}
                    {:id "3" :name "Three"}
                    {:id "4" :name "Four"}]
          ;; NOTE: This function will be applied to each option in the options-vector
          :options-transform (comp str/reverse :name)}}

        f-spec
        (-> spec
            (assoc :fields
                   field-spec))]

    [core/render f-spec data]))


(defn select-with-supplied-options-view
  [form-spec data options]
  (-> form-spec
      (assoc :fields {:select {:type :select :options options :label "Select: With supplied data"}})
      (core/render data)))

(defn view
  []
  (let [!form-data
        (subscribe [:form/data])

        form-spec*
        (-> form-spec
            (assoc-in [:fields :select :options] (get @!form-data :multiselect)))]

    [:div.container

     [core/render form-spec* @!form-data]
     [:h4
      "This example includes Materializecss just for the looks."]
     [:div.row.panel
      [:h4
       "Here is a look into the current app-state:"]
      [:pre
       (with-out-str (cljs.pprint/pprint @!form-data))]]
     [text/view @!form-data]
     [textarea/view @!form-data]
     [checkbox/view @!form-data]
     [select/view @!form-data]]))
