(ns de.phenomdevel.formalicious.components.app
  (:require
   [com.stuartsierra.component :as c]

   [de.phenomdevel.formalicious.components.app.handler :as handler]))


;; =============================================================================
;; Component


(defrecord App []

  c/Lifecycle

  (start [component]
    (println ";; [App] Started.")
    (assoc component
           :handler (handler/new-handler)))

  (stop [component]
    (println ";; [App] Stopped.")
    (assoc component :handler nil)))


;; =============================================================================
;; Component Constructor

(defn new-app
  [config]
  (map->App config))
