(ns de.phenomdevel.formalicious.helper
  (:require
   [plumbing.core :refer-macros [letk]]
   [re-frame.core :refer [subscribe dispatch-sync dispatch]]

   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.util.dom.element :as element]))



;; =============================================================================
;; Event Handler Helper
(defn- on-click-handler
  [handler]
  (fn []
    (dispatch (u/collify handler))))

(defn- on-change-handler
  [data-path value]
  (dispatch-sync [:state/update-at (u/collify data-path) value]))

(defn value-on-change-handler
  [data-path]
  (fn [e]
    (let [value
          (element/value e)]

      (on-change-handler data-path value))))

(defn checked-on-change-handler
  [data-path]
  (fn [e]
    (let [checked?
          (element/checked? e)]

      (on-change-handler data-path checked?))))


;; =============================================================================
;; Form-Field Attribute Helper

(defn with-value
  [attrs data data-path]
  (assoc attrs :value data))

(defn with-on-change
  [attrs on-change update-path]
  (cond-> attrs
    (fn? on-change)
    (assoc :on-change on-change)

    (nil? on-change)
    (assoc :on-change (value-on-change-handler update-path))))

(defn with-disabled
  [attrs disabled]
  (cond-> attrs
    (keyword? disabled)
    (assoc :disabled @(subscribe (u/collify disabled)))

    (fn? disabled)
    (assoc :disabled (disabled))

    (or (true? disabled) (false? disabled))
    (assoc :disabled disabled)))

(defn with-on-click
  [attrs on-click]
  (cond-> attrs
    (fn? on-click)
    (assoc :on-click on-click)

    (keyword? on-click)
    (assoc :on-click (on-click-handler on-click))))


;; =============================================================================
;; Form-Field Helper

(defn with-input-field-wrapper
  [attrs]
  [:div.input-field attrs])

(defn with-option-wrapper
  [attrs id]
  [:option (assoc attrs :key id)])

(defn with-select-field-wrapper
  [attrs]
  [:select.browser-default attrs])

(defn default-option
  [field-spec]
  (letk [[{label ""}]
         field-spec]

    [:option
     {:disabled
      true

      :value
      ""}
     label]))

(defn with-label
  [field-wrapper field-spec]
  (letk [[{id ""}
          {label nil}]
         field-spec

         label
         [:label
          {:for id}
          label]]

    (if label
      (conj field-wrapper label)
      field-wrapper)))

(defn with-contents
  [field-wrapper & contents]
  (into field-wrapper contents))
