(ns de.phenomdevel.formalicious.schema.form
  (:require
   [schema.core :as s]))

(def ReFrameEventPath
  (s/cond-pre s/Keyword [s/Keyword]))

(def Common
  {:type
   s/Keyword

   :label
   s/Str

   (s/optional-key :placeholder)
   (s/cond-pre s/Str s/Keyword)
   ;; If the placeholder is supplied as keyword it will be converted to a string and capitalized

   (s/optional-key :pos)
   s/Int

   (s/optional-key :class)
   s/Str

   (s/optional-key :data-path) ReFrameEventPath

   (s/optional-key :disabled) s/Any

   ,,,})

(def Select
  (merge Common
         {(s/optional-key :options) [s/Any]
          (s/optional-key :options-path) ReFrameEventPath
          (s/optional-key :options-label-key) s/Keyword
          (s/optional-key :options-transform) (s/either s/Keyword (s/pred fn?))
          (s/optional-key :order-by) (s/either (s/pred fn?) s/Keyword)}))

(def Text
  Common)

(def Password
  Common)

(def Textarea
  Common)

(def Button
  (merge Common
         {:on-click (s/pred fn?)}))

(def Checkbox
  Common)

(def Multiselect
  (merge Common
         {:multiple s/Bool}))

(def Radiobutton
  Common)

(def Datepicker
  Common)

(def FormSpec
  {:data-root
   ReFrameEventPath

   :fields
   {s/Keyword
    (s/either
     Select
     Text
     Button
     Password
     Textarea
     Checkbox
     Datepicker
     Multiselect
     Radiobutton)}})
