(ns example.core
  (:require
   [goog.dom :as gdom]

   [reagent.core :as reagent]
   [re-frame.core :refer [dispatch]]

   [example.handler]
   [example.subscription]

   [example.views.app :as app]))


;; =============================================================================
;; Mount

(defn mount!
  []
  (reagent/render [app/view]
    (gdom/getElement "app")))


;; =============================================================================
;; Figwheel

(defn on-jsload
  []
  (js/console.clear)
  (mount!))


;; =============================================================================
;; Init

(def seed
  {:example
   {:form-data
    {}}})

(defonce init!
  (do
    (dispatch [:initialize seed])
    (mount!)))
