(ns de.phenomdevel.formalicious.components.app.handler
  (:require
   [plumbing.core :refer [letk]]
   [compojure.route :as route]
   [compojure.core :as cp :refer [GET POST context]]

   [ring.middleware.params :as ring-mw-params]
   [ring.middleware.defaults :as ring-defaults]

   [de.phenomdevel.formalicious.util :as u]
   [de.phenomdevel.formalicious.view.app :as app]
   [de.phenomdevel.formalicious.view.error :as error]))


;; =============================================================================
;; Common Routes

(defn- new-routes
  []
  (cp/routes
    (route/resources "/")

    (GET "/app" req
      (app/view))

    (route/not-found (error/render))))


;; =============================================================================
;; Public API

(def ^:private ring-defaults
  (assoc-in ring-defaults/site-defaults [:security :anti-forgery] false))

(defn new-handler
  []
  (-> (new-routes)
      (ring-defaults/wrap-defaults ring-defaults)
      (ring-mw-params/wrap-params)))
