(ns example.views.app
  (:require
   [clojure.string :as str]

   [re-frame.core :refer [subscribe dispatch]]

   [de.phenomdevel.formalicious.core :as core]

   [example.views.text :as text]
   [example.views.textarea :as textarea]
   [example.views.checkbox :as checkbox]
   [example.views.select :as select]))


;; =============================================================================
;; View

(defn nav
  []
  (let [hrefs
        [["Textinput Examples" :text]
         ["Selectinput Examples" :select]]]

    [:div.nav
     (for [[label href] hrefs]
       ^{:key href}
       [:button
        {:on-click #(dispatch [:route/set href])}
        label])]))

(defn view
  []
  (let [!form-data
        (subscribe [:form/data])

        !route
        (subscribe [:route/current])]

    [:div
     [nav]
     (case @!route
       :text [text/view]
       :textarea [textarea/view]
       [:div "There is no content for this route."])]))
