(ns example.views.select
  (:require
   [plumbing.core :refer [map-vals]]
   [cljs.pprint :as pprint]
   [de.phenomdevel.formalicious.core :as formalicious]
   [clojure.string :as str]))

;; =============================================================================
;; Form-Spec

(def form-spec
  {:data-root
   [:example :form-data]

   :fields
   {:normal-select
    {:type :select
     :label "Select"
     :options [{:name "option 1" :label "Option One"}
               {:name "option 2" :label "Option Two"}
               {:name "option 3" :label "Option Three"}]
     :option-label-key :label
     :option-transform #(update % :label str/reverse)
     :order-by :name}}})


;; =============================================================================
;; View

(defn view
  [form-data]
  [:div.panel
   [:pre
    "The form-spec for following example looks like this: \n"
    (with-out-str (pprint/pprint form-spec))]
   [:style
    ".blue-text {color: blue;}"]
   [:h5 "Select Examples"]
   [formalicious/render form-spec form-data]])
