(ns example.views.text
  (:require
   [re-frame.core :refer [subscribe]]

   [example.util :as u]
   [de.phenomdevel.formalicious.core :as formalicious]))


;; =============================================================================
;; Helper

(def base-form-spec
  {:data-root
   [:example :form-data :text]

   :fields
   {}})


;; =============================================================================
;; Sub Views

(defn- normal-text-input
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :normal-text-input]
                      {:type :text
                       :label "Normal Textinput"
                       :placeholder "Normal Textinput Placeholder"}))]

    [:div.normal-text-input-example
     [:h3 "Normal Textinput"]
     "Here is the `form-spec` used to render the `form-field`:"
     [:pre
      (with-out-str (cljs.pprint/pprint form-spec))]
     [formalicious/render form-spec form-data]]))

(defn- text-input-with-data-path
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :text-input-with-data-path]
                      {:type :text
                       :label "Textinput with `data-path`"
                       :data-path [:example :form-data :text :another-path :text-input]}))]

    [:div.text-input-with-data-path-example
     [:h3 "Textinput with `data-path`"]
     "Here is the `form-spec` used to render the `form-field`:"
     [:pre
      (with-out-str (cljs.pprint/pprint form-spec))]
     [formalicious/render form-spec form-data]]))

(defn- disabled-text-input
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :disabled-text-input]
                      {:type :text
                       :label "Disabled Textinput"
                       :disabled (empty? (:normal-text-input form-data))}))]

    [:div.disabled-text-input-example
     [:h3 "Disabled Textinput"]
     "Here is the `form-spec` used to render the `form-field`:"
     [:pre
      (with-out-str (cljs.pprint/pprint form-spec))]
     "You can't see it because it is immediatly evaluated but the value behind :disabled is `(empty? (:normal-text-input form-data))`" [:br]
     "This `input-field` will be activated once you type in somthing in `normal-text-input`"
     [formalicious/render form-spec form-data]]))


;; =============================================================================
;; Public View

(defn view
  []
  (let [!form-data
        @(subscribe [:form/data :text])]

    [:div.panel
     [:div
      [:h2
       "Textinput Examples"
       [:br]
       "Here is the `app-state` for this example:"
       (u/data->html !form-data)]
      [:hr]
      [normal-text-input !form-data]
      [:hr]
      [text-input-with-data-path !form-data]
      [:hr]
      [disabled-text-input !form-data]]]))
