(ns de.phenomdevel.formalicious.core
  (:require
   [com.stuartsierra.component :as c]

   [de.phenomdevel.formalicious.components.app :as app]
   [de.phenomdevel.formalicious.components.server :as server])

  (:import
   [clojure.lang ExceptionInfo])

  (:gen-class))


;; =============================================================================
;; System

(defn new-system
  [config]
  (c/system-map

    :app
    (c/using
     (app/new-app (:app config))
     [])

    :server
    (c/using
     (server/new-server (:server config))
     [:app])

    ,,,))


;; =============================================================================
;; Main

(defn shutdown-hook
  [sys]
  (Thread. (fn []
             (println "\nReceived term signal, shutting down...")
             (c/stop sys))))

;; TODO: Read config from file
(def config
  {:server
   {:port 1338}

   ,,,})


(defn -main
  [& args]
  (try
    (let [system
          (c/start (new-system config))]

      (-> (Runtime/getRuntime)
          (.addShutdownHook (shutdown-hook system))))

    (catch ExceptionInfo e
      (let [system
            (-> e
                (.getData)
                :system)

            err-comp
            (-> e
                (.getData)
                :component)]

        (-> e
            (.getCause)
            (.printStackTrace))
        (println "Error in component" err-comp "\nTerminating application")
        (c/stop system)
        (System/exit 1)))))
