(ns example.views.textarea
  (:require
   [re-frame.core :refer [subscribe]]

   [example.util :as u]

   [de.phenomdevel.formalicious.core :as formalicious]))


;; =============================================================================
;; Form-Spec

(def base-form-spec
  {:data-root
   [:example :form-data :textarea]

   :fields
   {}})


;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Sub Views

(defn- normal-textarea
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :normal-textarea]
                      {:type :textarea
                       :label "Normal Textarea"
                       :placeholder "Normal Textarea"}))]

    [:div.normal-textarea-example
     [:h3 "Normal Textarea"]]))


;; =============================================================================
;; View

(defn view
  []
  (let [!form-data
        @(subscribe [:form/data :textarea])]

    [:div.panel
     [:div
      [:h2
       "Textarea Examples"
       [:br]
       "Here is the `app-state` for this example:"
       (u/data->html !form-data)]
      [:hr]]]))
