(ns example.views.checkbox
  (:require
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.core :as formalicious]

   [example.util :as u]))



;; =============================================================================
;; Form-Spec

(def base-form-spec
  {:data-root
   [:example :form-data :checkbox]

   :fields
   {}})


;; =============================================================================
;; Sub Views

(defn normal-checkbox
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :normal-checkbox]
                      {:type :checkbox
                       :label "Nomal Checkbox"}))]

    [:div.normal-checkbox
     [:h3 "Normal Checkbox"]
     "Here is the `form-spec` used to render the `form-field`:"
     (u/data->html form-spec)
     [formalicious/render form-spec form-data]]))

(defn dependant-checkboxes
  [form-data]
  (let [form-spec
        (-> base-form-spec
            (assoc-in [:fields :checkbox-1]
                      {:type :checkbox
                       :label "Checkbox One"})
            (assoc-in [:fields :checkbox-2]
                      {:type :checkbox
                       :label "Checkbox Two"
                       :disabled (boolean (not (:checkbox-1 form-data)))})
            (assoc-in [:fields :checkbox-3]
                      {:type :checkbox
                       :label "Checkbox Three"
                       :disabled (boolean (not (:checkbox-2 form-data)))}))]

    [:div.dependant-checkboxes
     [:h3 "Dependant Checkboxes"]
     [:h4 "`form-spec`:"]
     (u/data->html form-spec)
     [:h4 "`app-state`:"]
     (u/data->html form-data)
     [formalicious/render form-spec form-data]]))

;; =============================================================================
;; View

(defn view
  []
  (let [!form-data
        @(subscribe [:form/data :checkbox])]

    [:div
     [:h5 "Checkbox Examples"]
     [:br]
     "Here is the `app-state` for this example:"
     (u/data->html !form-data)
     [:hr]
     [normal-checkbox !form-data]
     [:hr]
     [dependant-checkboxes !form-data]]))
