(ns de.phenomdevel.formalicious.components.scheduler
  (:require
   [clojure.core.async :as async]

   [plumbing.core :refer [letk]]

   [com.stuartsierra.component :as c]))


;; =============================================================================
;; Component

(defrecord Scheduler [interval stopped stop-ch]
  c/Lifecycle
  (start [component]
    (let [schedule-channel
          (async/go-loop []
            (async/<! (async/timeout interval))
            (println "Starting scheduled task")
            (when (async/alt! stop-ch false :default true)
              (recur)))]
      
      (println (format ";; [Scheduler] Started with interval %s" interval))
      
      (assoc component :schedule-channel schedule-channel)))

  (stop [component]
    (letk [[{schedule-channel nil}
            {stop-ch nil}]
           component]

      (when stop-ch
        (async/put! stop-ch true))

      (println ";; [Scheduler] Stopped")

      (cond-> component
        schedule-channel
        (assoc :schedule-channel (async/close! schedule-channel))))))


;; =============================================================================
;; Component Constructor

(defn new-scheduler
  [config]
  (map->Scheduler (assoc config :stop-ch (async/chan))))









(comment

  (def queue
    (async/go-loop []
      (async/<! (async/timeout 10000))
      (println "test")
      (recur)))

  (async/close! queue)
  )
