(ns de.phenomdevel.formalicious.db
  (:require
   [clojure.java.jdbc :as jdbc]))

;; MONCON
;; TODO: Exchange with MySQL Database and connectionpool

(def ^:private db-spec
  {:classname "org.h2.Driver"
   :subprotocol "h2:file"
   :subname "./db/moncon"
   :user "sa"
   :password ""})

(def id-column
  [:id "INTEGER PRIMARY KEY AUTO_INCREMENT"])

(def ^:private tables
  [[:linkage
    [id-column
     [:name "VARCHAR(100) NOT NULL"]]]

   [:user
    [id-column
     [:email "VARCHAR(255) NOT NULL"]
     [:linkage_id "INTEGER NOT NULL"]
     ["FOREIGN KEY (linkage_id) REFERENCES linkage(id)"]]]])

(defn drop-tables
  []
  (jdbc/with-db-connection [conn db-spec]
    (doall
      (doseq [[table _] tables]
        (jdbc/db-do-commands conn (jdbc/drop-table-ddl table))))))

(defn create-tables
  []
  (jdbc/with-db-connection [conn db-spec]
    (doall
      (doseq [[table columns] tables]
        (jdbc/db-do-commands conn (apply jdbc/create-table-ddl table columns))))))

(defn reset-db
  []
  (drop-tables)
  (create-tables))
