(ns de.phenomdevel.formalicious.form.button
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{class ""}
          {label ""}
          {on-click nil}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (h/with-on-click on-click))]

    (fn [field-spec value]
      (letk [[{disabled false}]
             field-spec

             attrs
             (h/with-disabled base-attrs disabled)]

        [:button.pd__button
         (assoc attrs :class class)
         label]))))
