(ns de.phenomdevel.formalicious.form.multiselect
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.util.dom.element :as element]

   [de.phenomdevel.formalicious.form.select :as select]))


;; =============================================================================
;; Public API
;; TODO: Understand weird rendering chrome bug (double on-change firing)
(defn on-change
  [data-path v]
  (fn [e]
    (let [options
          (element/options e)]

      (if (not= v options)
        (h/on-change-handler data-path options)))))

(defn render
  [field-spec value]
  (letk [[{data-path nil}]
         field-spec]

    (fn [field-spec value]
      (let [on-change
            (on-change data-path value)

            field-spec*
            (assoc field-spec
                   :type :select
                   :multiple true
                   :on-change on-change)]

        [select/render field-spec* (or value [])]))))
