(ns de.phenomdevel.formalicious.form.password
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{class nil}
          {data-path nil}
          {on-change nil}
          {value-transform identity}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (h/with-on-change on-change value-transform data-path))]

    (fn [field-spec value]
      (let [attrs
            (-> base-attrs
                (h/with-value value)
                (h/with-disabled (:disabled field-spec)))]

        (-> {:class class}
            (h/with-input-field-wrapper)
            (h/with-label field-spec)
            (h/with-contents [:input.pd__input.pd__input__password attrs]))))))
