(ns de.phenomdevel.formalicious.form.radiobutton
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{id ""}
          {class ""}
          {data-path nil}
          {value-transform identity}]
         field-spec

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (assoc :type :radio)
             (h/with-on-change nil value-transform data-path))]

    (fn [field-spec value]
      (letk [[{disabled false}]
             field-spec

             checked?
             (or (:checked? field-spec)
                 (= (name id) value))

             attrs
             (-> base-attrs
                 (assoc :value id)
                 (assoc :checked checked?)
                 (h/with-disabled disabled))]

        (-> {:class class :key id}
            (h/with-input-field-wrapper)
            (h/with-label field-spec)
            (h/with-contents [:input.pd__radiobutton attrs]))))))
