(ns de.phenomdevel.formalicious.view.common
  (:require
   [plumbing.core :refer [letk]]
   [hiccup.core :refer [html]]
   [hiccup.page :as page]))


;; =============================================================================
;; Helper

(defn page
  [& body-content]
  (html
    [:head
     [:meta
      {:name "viewport"
       :content "width=device-width, initial-scale=1.0"}]
     (page/include-css
      "css/pikaday.min.css"
      "css/font-awesome.min.css"
      "css/mui.css"
      "css/main.css"
      "css/mui-colors.css"
      "css/normalize-3.0.3.css")
     (page/include-js
      "js/jquery-3.2.1.min.js"
      "js/mui.min.js"
      "js/moment.min.js"
      "js/pikaday.min.js")
     [:title "Formalicious Beispiel"]]

    ,,,

    [:body
     body-content]))
