(ns example.views.form-one
  (:require
   [re-frame.core :refer [subscribe]]

   [de.phenomdevel.formalicious.core :as form]

   [example.views.state :as state]))


;; =============================================================================
;; Helper

(def ^:private form-spec
  {:data-root
   [:form :data :one]

   :fields
   [{:id :salutation
     :type :select
     :options ["" "Madam" "Sir"]
     :label "Salutation"
     :class "mui-select mui-col-xs-3"}
    {:id :firstname
     :type :text
     :label "Firstname"
     :class "mui-textfield mui-col-xs-3"}
    {:id :lastname
     :type :text
     :label "Lastname"
     :class "mui-textfield mui-col-xs-3"}
    {:id :street
     :type :text
     :label "Street"
     :class "mui-textfield mui-col-xs-6"}]})


;; =============================================================================
;; Public API

(defn render
  []
  (let [!form-data
        (subscribe [:state/get-at (:data-root form-spec)])]

    [:div.form-one.mui-panel.mui-row
     [:h2 "Personal information"]
     [:div
      "Form-Data-Path " (pr-str (:data-root form-spec))
      [state/render @!form-data]]
     [form/render-form form-spec]]))
