(ns de.phenomdevel.formalicious.form.date
  (:require
   [reagent.core :as reagent]
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[id
          {class nil}
          {label ""}
          {data-path []}
          {value-transform identity}]
         field-spec

         on-change
         (fn [picker _]
           (let [value
                 (.toString picker)]

             (h/on-change-handler data-path value)))

         base-attrs
         (-> field-spec
             (shared/field-spec->attrs)
             (h/with-on-change on-change value-transform data-path))]

    (reagent/create-class
     {:display-name
      (str "formalicious__datepicker__" id)

      :component-did-mount
      (fn [this]
        (when-let [input
                   (js-invoke js/document "getElementById" (name id))]

          (let [date-picker
                (js/Pikaday.
                 (clj->js
                  {:field input
                   :theme ""
                   :firstDay 1
                   :format "DD.MM.YYYY"}))]

            (when date-picker
              (reagent/set-state this {:date-picker date-picker})
              (aset date-picker "_o" "onSelect" (partial on-change date-picker))))))

      :component-will-unmount
      (fn [this]
        (when-let [date-picker
                   (-> this
                       (reagent/state)
                       :date-picker)]

          (js-invoke date-picker "hide")
          (js-invoke date-picker "destroy")))

      :reagent-render
      (fn [field-spec value]
        (letk [[{disabled false}]
               field-spec

               attrs
               (-> base-attrs
                   (h/with-value value)
                   (h/with-disabled disabled))]

          (-> {:class class}
              (h/with-input-field-wrapper)
              (h/with-label field-spec)
              (h/with-contents [:input (dissoc attrs :type)]))))})))
