(ns de.phenomdevel.formalicious.form.paragraph
  (:require
   [plumbing.core :refer [letk]]

   [de.phenomdevel.formalicious.helper :as h]
   [de.phenomdevel.formalicious.form.shared :as shared]))


;; =============================================================================
;; Private Helper

(defn- -render
  [field-spec value]
  (letk [[{id nil}
          {class nil}]
         field-spec]

    ^{:key (or id value)}
    [:p.pd__paragraph
     (h/with-class {} field-spec)
     value]))


;; =============================================================================
;; Public API

(defn render
  [field-spec _]
  (letk [[{data-path nil}
          {render-fn -render}]
         field-spec

         base-attrs
         (shared/field-spec->attrs field-spec)]

    (fn [field-spec value]
      [render-fn field-spec value])))
